package canne.jpassmate.ui;

import javax.swing.table.*;
import canne.jpassmate.*;

/**
 * Title:        Java PassMate
 * Description:  Application to store encrypted passwords
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author Canne
 * @version 1.0
 */

public class TableModel extends AbstractTableModel implements Localization {

  private String[] columnTitles = {
    lang.getString("Name"),
    lang.getString("Password"),
    lang.getString("URL"),
    lang.getString("Notes")};
  private java.util.Vector data = new java.util.Vector();

/**
 * Construct an empty TableModel
 */
  public TableModel() {
  }//Constructor()

/**
 * Add a row to the bottom of the table
 */
  public void addRow(String name, char[] password, String url, String notes) {
    data.addElement(new PassMateData(name, password, url, notes));
    this.fireTableDataChanged();
  }//public void addRow(String, char[], String, String)

/**
 * Remove a row from the table
 */
  public PassMateData removeRow(int index) {
    System.out.println("index: "+index);
    PassMateData result = (PassMateData)data.remove(index);
    this.fireTableDataChanged();
    return result;
  }//public PassMateData removeRow(int)

/**
 * Remove all rows from the table
 */
  public void removeAllRows() {
    data.clear();
  }//public void removeAllRows()

/**
 * Modify the table headers
 */
  public void setColumnHeaders(Object lblName, Object lblPassword, Object lblURL, Object lblNotes) {
    data.setElementAt(new PassMateData(lblName.toString(), lblPassword.toString().toCharArray(), lblURL.toString(), lblNotes.toString()), 0);
  }//public void setColumnHeaders(Object, Object, Object, Object)

/**
 * Return the number of columns in this table
 */
  public int getColumnCount() {
    return columnTitles.length;
  }//public int getColumnCount()

/**
 * Return a <CODE>String</CODE> with the data in the specified cell
 */
  public Object getValueAt(int row, int column) {
    if(data.size() > row) {
      switch(column) {
        case Config.NAME_COLUMN:
          return ((PassMateData)data.elementAt(row)).getName();
        case Config.PASSWORD_COLUMN:
          return ((PassMateData)data.elementAt(row)).getPassword();
        case Config.URL_COLUMN:
          return ((PassMateData)data.elementAt(row)).getURL();
        default:
          return ((PassMateData)data.elementAt(row)).getNotes();
      }//switch
    }//if
    return null;
  }//public Object getValueAt(int, int)

/**
 * Modify the value in the specified cell
 */
  public void setValueAt(Object value, int row, int column) {
    switch(column) {
      case Config.NAME_COLUMN:
        ((PassMateData)data.elementAt(row)).setName((String)value);
        break;
      case Config.PASSWORD_COLUMN:
        ((PassMateData)data.elementAt(row)).setPassword(/*(char[])*/((String)value).toCharArray());
        break;
      case Config.URL_COLUMN:
        ((PassMateData)data.elementAt(row)).setURL((String)value);
        break;
      case Config.NOTES_COLUMN:
        ((PassMateData)data.elementAt(row)).setNotes((String)value);
        break;
    }//switch
  }//public void setValueAt(Object, int, int)

/**
 * Return the number of rows in this table
 */
  public int getRowCount() {
    return data.size();
  }//public int getRowCount()

/**
 * Return an <CODE>Object[]</CODE> with the data in the specified row
 */
  public PassMateData getRow(int rowIndex) {
    return (PassMateData)data.elementAt(rowIndex);
  }//public PassMateData getRow(int)

/**
 * Return the name (header) of the specified column
 */
  public String getColumnName(int col) {
    return columnTitles[col];
  }//public String getColumnName(int)

  public Class getColumnClass(int c) {
//    System.out.println("Column class ("+c+"): "+data.get(0).getClass());
    return getValueAt(0, c).getClass();
//    return data.get(0).getClass();
  }//public Class getColumnClass(int)

/**
 * Alwais return <CODE>true</CODE>
 */
  public boolean isCellEditable(int row, int col) {
    return true;
  }//public boolean isCellEditable(int, int)

  public java.util.Vector getDataVector() {
    return data;
  }//public Vector getPassMateDataVector()

  public void setDataVector(java.util.Vector newData) {
    data = newData;
    this.fireTableDataChanged();
  }//public void setPassMateDataVector(Vector)

}//class TableModel
