package canne.jpassmate.ui;

import canne.jpassmate.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
//import javax.swing.table.*;
import java.io.*;
import java.util.*;


/**
 * Swing.java
 *
 *
 * Created: Wed Oct 29 18:22:05 2003
 *
 * @author <a href="mailto:">Nicola Canepa</a>
 * @version 1.0
 */
public class Swing extends JFrame implements UI, ActionListener, WindowListener, javax.swing.event.ListSelectionListener, Localization {

//   java.util.ResourceBundle lang = java.util.ResourceBundle.getBundle("canne.jpassmate.Locale");

//  JFrame frame = null;
  String argv[] = null;
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu(lang.getString("File")), jMenuEdit = new JMenu(lang.getString("Edit")), jMenuHelp = new JMenu(lang.getString("Help"));
  JMenuItem jMenuFileNew = new JMenuItem(lang.getString("New")), jMenuFileLoad = new JMenuItem(lang.getString("Open")+"..."), jMenuFileSave = new JMenuItem(lang.getString("Save")), jMenuFileSaveAs = new JMenuItem(lang.getString("Save as")+"..."), jMenuFileChangePassword = new JMenuItem(lang.getString("Change Password")+"..."), jMenuFileExit = new JMenuItem(lang.getString("Exit"));
  JMenuItem jMenuEditAdd = new JMenuItem(lang.getString("Add")+"..."), jMenuEditDelete = new JMenuItem(lang.getString("Delete")), jMenuEditCut = new JMenuItem(lang.getString("Cut")), jMenuEditCopy = new JMenuItem(lang.getString("Copy")), jMenuEditPaste = new JMenuItem(lang.getString("Paste")), jMenuEditLaunchurl = new JMenuItem(lang.getString("Launch URL")), jMenuEditSearch = new JMenuItem(lang.getString("Search")), jMenuEditProperties = new JMenuItem(lang.getString("Properties")+"...");
  JMenuItem jMenuHelpAbout = new JMenuItem(lang.getString("About"));
  JToolBar jToolBar = new JToolBar();
//   ImageIcon image1 = new ImageIcon(class.getResource("openFile.gif"));
//   ImageIcon image2 = new ImageIcon(class.getResource("closeFile.gif"));
//   ImageIcon image3 = new ImageIcon(class.getResource("help.gif"));
  JButton btnLoad = new JButton(lang.getString("Open")/*, image1*/);
  JButton btnSave = new JButton(lang.getString("Save")/*, image2*/);
  JButton btnHelp = new JButton(lang.getString("Help")/*, image3*/);
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  TitledBorder titledBorder1;
  JFileChooser fileChooser = null;
  canne.jpassmate.io.FileFilterWithDescription fileFilterJPM,
    fileFilterXML,
    fileFilterCSV;

  final static String TITLE = "jPassMate";
//   PassMateCore passMateCore = null;
//   PasswordData passwordData = new PasswordData();
/**
 * tableData contains all the real data, and a Component to display it
 */
  private TableModel tableData = new TableModel();

  JTable tblData = new JTable(tableData);
//   char password[] = null;
  boolean modified = false;

  PasswordData currentData = new PasswordData();
//  byte currentFileType = Config.FILE_NONE;
//  File currentFile = null;
//  IO io;
  Logger logger;

  public Swing(String argv[]) {
    this.argv = argv;
  }//Constructor()

  public void setParam(String name, Object value) {
  }//public void setParam(String, Object)

  public Object getParam(String name) {
    return null;
  }//public Object getParam(String)

  public void startUI() {
    logger = new canne.jpassmate.logger.Stderr();
    if(Boolean.getBoolean("DEBUG"))
      logger.setLevel((byte)10);
    //frame.setIconImage(Toolkit.getDefaultToolkit().createImage(jPassMate.class.getResource("[Your Icon]")));
    contentPane = (JPanel) getContentPane();
    titledBorder1 = new TitledBorder("");
    contentPane.setLayout(borderLayout1);
    setSize(new Dimension(400, 300));
    setTitle(TITLE);
    statusBar.setText(" ");

    /* <Shortcuts> */
    jMenuEditDelete.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D, KeyEvent.CTRL_MASK));
    jMenuEditCut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, KeyEvent.CTRL_MASK));
    jMenuEditPaste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, KeyEvent.CTRL_MASK));
    /* </Shortcuts> */

    jMenuFileNew.addActionListener(this); jMenuFileLoad.addActionListener(this);
    jMenuFileSave.addActionListener(this); jMenuFileSaveAs.addActionListener(this);
    jMenuFileChangePassword.addActionListener(this); jMenuFileExit.addActionListener(this);
    jMenuEditAdd.addActionListener(this); jMenuEditDelete.addActionListener(this);
    jMenuEditCut.addActionListener(this); jMenuEditCopy.addActionListener(this);
    jMenuEditPaste.addActionListener(this);
    jMenuEditLaunchurl.addActionListener(this); jMenuEditSearch.addActionListener(this);
    jMenuEditProperties.addActionListener(this);
    jMenuHelpAbout.addActionListener(this); btnLoad.addActionListener(this);
    btnSave.addActionListener(this);
    tblData.setBorder(BorderFactory.createLoweredBevelBorder());
    jToolBar.add(btnLoad); jToolBar.add(btnSave);
    jToolBar.add(btnHelp);
    jMenuFileChangePassword.setEnabled(false);
    jMenuEditDelete.setEnabled(false);
    jMenuEditCut.setEnabled(false); jMenuEditCopy.setEnabled(false);
    jMenuEditPaste.setEnabled(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) instanceof java.awt.datatransfer.StringSelection);
    jMenuEditLaunchurl.setEnabled(false); jMenuEditSearch.setEnabled(false); jMenuEditProperties.setEnabled(false);
    jMenuFile.add(jMenuFileNew); jMenuFile.add(jMenuFileLoad);
    jMenuFile.add(jMenuFileSave); jMenuFile.add(jMenuFileSaveAs);
    jMenuFile.addSeparator(); jMenuFile.add(jMenuFileChangePassword);
    jMenuFile.addSeparator(); jMenuFile.add(jMenuFileExit);
    jMenuEdit.add(jMenuEditAdd); jMenuEdit.add(jMenuEditDelete);
    jMenuEdit.addSeparator(); jMenuEdit.add(jMenuEditCut);
    jMenuEdit.add(jMenuEditCopy); jMenuEdit.add(jMenuEditPaste);
    jMenuEdit.addSeparator(); jMenuEdit.add(jMenuEditLaunchurl);
    jMenuEdit.add(jMenuEditSearch); jMenuEdit.add(jMenuEditProperties);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile); jMenuBar1.add(jMenuEdit);
    jMenuBar1.add(jMenuHelp);
    setJMenuBar(jMenuBar1);
    tblData.setDefaultRenderer((new char[] {}).getClass(), new jpmTableCellRenderer());
    tblData.setDefaultEditor((new char[] {}).getClass(), new jpmTableCellEditor());
    tblData.getSelectionModel().addListSelectionListener(this);
    contentPane.add(jToolBar, BorderLayout.NORTH);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    contentPane.add(new JScrollPane(tblData), BorderLayout.CENTER);

//     passMateCore.addPassMateListener(this);
    addWindowListener(this);
    logger.log(6, "About to start GUI: "+this+" {"+contentPane+"}");

    if(argv.length > 0 && !argv[0].startsWith("-")) {
      try {
        load(new File(argv[0]));
      } catch(org.jdom.JDOMException jde) {
        jde.printStackTrace();
      } catch(java.io.FileNotFoundException fnfe) {
        fnfe.printStackTrace();
      }
    }

    setVisible(true);
  }//void startUI(Frame)

  /**
   * Ritorna l'attuale IO. Se nullo, ritorna una nuova istanza di IO (con un Dialog).
   */
  public IO getIO() {
    if(currentData.getIO() == null) {
//      char[] pass = null;
//      pass = askPassword();
//      if(pass != null)
      log(1, "New Crypto");
      currentData.setIO(new canne.jpassmate.io.Crypto(this));
      currentData.getIO().addLogger(logger);
    }//if
    logger.log(8, "Returning IO: "+currentData.getIO());
    return currentData.getIO();
  }//IO getIO()

  /**
   * Ritorna una nuova istanza di IO (con un Dialog), a meno che l'utente non prema annulla.
   * In tal caso viene ripristinata la precedente e ritorna null.
   */
  public IO getNewIO() {
    IO oldIO = currentData.setIO(null);
    if(getIO() == null) {
      currentData.setIO(oldIO);
      return null;
    }//if
    return currentData.getIO();
  }//IO getNewIO()

  /**
   * Imposta a null l'IO attuale, e ne ritorna il valore.
   */
  public IO clearIO() {
    logger.log(8, "Clearing IO "+currentData.getIO());
    return currentData.setIO(null);
  }//IO clearIO()

  /**
   * Imposta l'IO attuale, e ne ritorna il precedente valore.
   */
  public IO setIO(IO newIO) {
    return currentData.setIO(newIO);
  }//IO setIO(IO)

  char[] askPassword() {
    return askPassword(false);
  }//char[] askPassword()

  public char[] askPassword(boolean confirm) {
    JPasswordField jpf = new JPasswordField();
    char[] result = null;
    logger.log(8, "Asking new password");
    if(confirm) {
      JPasswordField jpfC = new JPasswordField();
      if(JOptionPane.showConfirmDialog(this, new Object[] {jpf, jpfC}, lang.getString("Insert password"), JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION) {
        if((new String(jpf.getPassword())).equals(new String(jpfC.getPassword())))
          result = jpf.getPassword();
        else
          JOptionPane.showMessageDialog(this, lang.getString("Passwords do not match"));
      }//if YES
    } else {
      if(JOptionPane.showConfirmDialog(this, new Object[] {jpf}, lang.getString("Insert password"), JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION)
        result = jpf.getPassword();
    }//if confirm
    logger.log(2, "Returning password: "+(result != null?"XXXXXX":"null"));
    return result;
  }//char[] askPassword(boolean)

  public void fileLoaded() {
    setModified(false);
  }//void fileLoaded()

  void load(File file) throws org.jdom.JDOMException, FileNotFoundException {
    boolean cancel = false;
    Vector data = null;
    while(!cancel && getNewIO() != null) {
//      if(getNewIO() != null)
        try {
          data = getIO().load(file);
          if(data != null) {
            cancel = true;
            tableData.setDataVector(data);
            logger.log((byte)2, "Loaded data file: "+data.elementAt(0));
          }
        } catch(canne.jpassmate.io.WrongPasswordException wpe) {
          logger.log(8, "Wrong password for file "+file);
          cancel = JOptionPane.showConfirmDialog(this, lang.getString("Wrong password: retry?"), lang.getString("Retry?"), JOptionPane.YES_NO_OPTION) == JOptionPane.NO_OPTION;
          logger.log(8, "Cancel password: "+cancel);
        } catch(org.jdom.JDOMException je) {
          throw je;
        } catch(Exception e) {
          e.printStackTrace();
          cancel = true;
        }//catch
    }//while
  }//void load(File)

  void save(File file) {
    Vector data = new Vector();
    if(getIO() != null) {
      try {
        getIO().save(file, data);
      } catch(Exception e) {
        e.printStackTrace();
      }//catch
    }//if
  }//void save(File)

/**
 * Asks for data and adds a line to <CODE>passwordData.tableData</CODE>
 */
  void addPassword() {
    JTextField tfName = new JTextField(),
      tfURL = new JTextField();
    JPasswordField tfPassword = new JPasswordField();
    String s = JOptionPane.showInputDialog(this,
      new Object[] {new JLabel(lang.getString("Name")), tfName,
        new JLabel(lang.getString("Password")), tfPassword,
        new JLabel(lang.getString("URL")), tfURL,
        new JLabel(lang.getString("Notes"))},
      lang.getString("Add")+"...", JOptionPane.PLAIN_MESSAGE);
    if(s != null) {
      tableData.addRow(tfName.getText(), tfPassword.getPassword(), tfURL.getText(), s);
    }//if
//    doLayout();
    setModified(true);
    repaint();
  }//void addPassword()

  void removePassword(int row) {
    tableData.removeRow(row);
    setModified(true);
    repaint();
  }//void removePassword()

  /**Help | About action performed*/
  public void showAbout() {
    Swing_AboutBox dlg = new Swing_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize(), frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.setVisible(true);
  }//public void showAbout()

  void setModified(boolean newValue) {
    if(newValue && !modified)
      setTitle(getTitle()+" *");
    else if(!newValue && modified)
      setTitle(getTitle().substring(0, getTitle().length() - 2));
    modified = newValue;
  }//void setModified(boolean)

  String buildTitle() {
    return (currentData.getFile() != null ? currentData.getFile().getName()+" - ":"")+TITLE+(modified?" *":"");
  }//String buildTitle()

/**
 * Return the password <CODE>File</CODE>, asking for one if no file is open.
 * @param mode: 1 for Open, 2 for Save
 */
  private File getPasswordFile(int mode) {
    if(currentData.getFile() == null) {
      File file = selectFile(mode);
      if(file != null) {
        if(fileChooser.getFileFilter() == fileFilterJPM) {
          if(!file.exists() && !file.getName().toLowerCase().endsWith(".jpm"))
            file = new File(file.getAbsolutePath()+".jpm");
          currentData.setFileType(Config.FILE_JPM);
        }//if JPM
        else if(fileChooser.getFileFilter() == fileFilterXML) {
          if(!file.exists() && !file.getName().toLowerCase().endsWith(".xml"))
            file = new File(file.getAbsolutePath()+".xml");
          currentData.setFileType(Config.FILE_XML);
        }//if XML
        else if(fileChooser.getFileFilter() == fileFilterCSV) {
          if(!file.exists() && !file.getName().toLowerCase().endsWith(".csv"))
            file = new File(file.getAbsolutePath()+".csv");
          currentData.setFileType(Config.FILE_CSV);
        }//if CSV
        currentData.setFile(file);
//        setTitle(buildTitle());
      }//if
    }//if null
    return currentData.getFile();
  }//File getPasswordFile()

/**
 * Ask the user for a file. It looks in user current directory.
 * @param mode: 1 for Open, 2 for Save
 */
  File selectFile(int mode) {
    return selectFile(mode, new File("."));
  }//File selectFile(int)

/**
 * Ask the user for a file.
 * @param mode: 1 for Open, 2 for Save
 * @param currDir: the directory to set as current in the JFileChooser
 */
  File selectFile(int mode, File currDir) {
    File selectedFile = null;
    int result = -1;
    if(fileChooser == null) {
      fileFilterJPM = new canne.jpassmate.io.FileFilterWithDescription();
      fileFilterXML = new canne.jpassmate.io.FileFilterWithDescription();
      fileFilterCSV = new canne.jpassmate.io.FileFilterWithDescription();
      fileChooser = new JFileChooser(currDir);
      fileFilterJPM.addExtension("jpm");
      fileFilterJPM.setDescription(lang.getString("jPassMate files"));
      fileFilterXML.addExtension("xml");
      fileFilterXML.setDescription(lang.getString("Unencrypted XML files"));
      fileFilterCSV.addExtension("csv");
      fileFilterCSV.addExtension("txt");
      fileFilterCSV.setDescription(lang.getString("Unencrypted CSV files"));
      fileChooser.addChoosableFileFilter(fileFilterJPM);
      fileChooser.addChoosableFileFilter(fileFilterCSV);
      fileChooser.addChoosableFileFilter(fileFilterXML);
      fileChooser.setFileFilter(fileFilterJPM);
    }//if
    switch(mode) {
      case 1:
        result = fileChooser.showOpenDialog(this);
        break;
      case 2:
        result = fileChooser.showSaveDialog(this);
        break;
    }//switch
    if(result == JFileChooser.APPROVE_OPTION)
      selectedFile = fileChooser.getSelectedFile();
    return selectedFile;
  }//File selectFile(int)

  void newTable() {
    boolean clearData = true;
    if(modified) {
      int option = JOptionPane.showConfirmDialog(this, lang.getString("Data was modified: save?"));
      switch(option) {
        case JOptionPane.OK_OPTION:
          save();
          tableData.removeAllRows();
          break;
        case JOptionPane.NO_OPTION:
          tableData.removeAllRows();
          break;
        default:
          clearData = false;
          break;
      }//switch
    }//if
    if(clearData) {
      tableData.removeAllRows();
      setTitle(buildTitle());
    }//if
  }//void newTable()

/**
 * Load a vector of PassMateData (data) from an (unencrypted) XML file
 */
/*  public void loadXML(File file) throws FileNotFoundException, org.jdom.JDOMException, IOException {
    canne.jpassmate.io.XML xmlio = new canne.jpassmate.io.XML();
    Vector newDataVector = xmlio.load(file);
    tableData.setDataVector(newDataVector);
  }//public void loadXML(File) throws FileNotFoundException, org.jdom.JDOMException
*/
/**
 * Save a vector of PassMateData (data) to an (unencrypted) XML file
 */
/*  public void saveXML(File file) throws FileNotFoundException, org.jdom.JDOMException, IOException {
    canne.jpassmate.io.XML xmlio = new canne.jpassmate.io.XML();
    xmlio.save(file, tableData.getDataVector());
  }//public void saveXML(File) throws FileNotFoundException, org.jdom.JDOMException
*/
/**
 * Load a vector of PassMateData (data) from an (unencrypted) CSV file
 */
/*  public void loadCSV(File file) throws FileNotFoundException, IOException, canne.jpassmate.io.CSVFormatException {
    canne.jpassmate.io.CSV csvio = new canne.jpassmate.io.CSV();
    Vector newDataVector = csvio.load(file);
    tableData.setDataVector(newDataVector);
  }//public void loadCSV(File) throws FileNotFoundException, org.jdom.JDOMException
*/
/**
 * Save a vector of PassMateData (data) to an (unencrypted) CSV file
 */
/*  public void saveCSV(File file) throws FileNotFoundException, IOException {
    canne.jpassmate.io.CSV csvio = new canne.jpassmate.io.CSV();
    csvio.save(file, tableData.getDataVector());
  }//public void saveCSV(File) throws FileNotFoundException, org.jdom.JDOMException
*/
/**
 * Save the passwords to file, asking for file name and password even if a file
 * is open.
 */
  private void saveAs() {
    PasswordData oldData = currentData;
    currentData = new PasswordData();
/*    File oldFile = currentFile;
    IO oldIO = clearIO();
    currentFile = null;*/
    save();
    if(currentData.getFile() == null) {
      currentData = oldData;
//      setIO(oldIO);
    }//if saving canceled
    else {
      oldData = null;
//      oldIO = null;
      setTitle(buildTitle());
    }//else
  }//void saveAs()

/**
 * Save the passwords to an encrypted file, asking for file name if no file is
 * open and for password if none was given before.
 * @return true if file was saved, false otherwise
 */
  private boolean save() {
    boolean result = false;
//    String fileName = JOptionPane.showInputDialog(this, lang.getString("Insert file name"));
    if(getPasswordFile(2) != null) {
      if(currentData.getFileType() == Config.FILE_JPM) {
        try {
//          if(getNewIO() != null) {
            getIO().save(currentData.getFile(), tableData.getDataVector());
            setModified(false);
            result = true;
//          }//if pass not null
        } catch(javax.crypto.NoSuchPaddingException nspe) {
          showException(nspe);
        } catch(java.security.NoSuchAlgorithmException nsae) {
          showException(nsae);
        } catch(java.security.InvalidKeyException ike) {
          showException(ike);
        } catch(java.security.spec.InvalidKeySpecException ikse) {
          showException(ikse);
        } catch(java.io.FileNotFoundException fnfe) {
          showException(fnfe);
        } catch(java.io.IOException ioe) {
          showException(ioe);
        } catch(Exception e) {
          showException(e);
        }//catch
      }//if native (JPM)
      else if(JOptionPane.showConfirmDialog(this, lang.getString("Warning: saving unencrypted data!")) == JOptionPane.OK_OPTION) {
//         if(currentFileType == Config.FILE_XML) {
          try {
            getIO().save(currentData.getFile(), tableData.getDataVector());
            result = true;
          } catch(java.io.FileNotFoundException fnfe) {
            showException(fnfe);
          } catch(java.io.IOException ioe) {
            showException(ioe);
          } catch(Exception e) {
            showException(e);
          }//catch
//         }//if XML
//         else if(currentFileType == Config.FILE_CSV) {
//           try {
//             saveCSV(currentFile, tableData.getDataVector());
//             result = true;
//           } catch(java.io.FileNotFoundException fnfe) {
//             showException(fnfe);
//           } catch(java.io.IOException ioe) {
//             showException(ioe);
//           }//catch
//         }//if CSV
      }//if confirmed
    }//if filename not null
    return result;
  }//boolean save()

/**
 * Load the passwords from an encrypted file, asking for file name and password.
 * @return true if file was loaded, false otherwise
 */
  boolean load() {
    boolean result = false;
//    byte oldFileType = currentFileType;
//    File oldFile = currentFile;
    /* Save old data */
//     IO oldIO = clearIO();
     PasswordData oldData = currentData;
     currentData = new PasswordData();
//    currentFile = null;
    if(getPasswordFile(1) != null) {
      if(currentData.getFileType() == Config.FILE_JPM) {
        if(getNewIO() != null) {
          try {
            load(currentData.getFile());
            setModified(false);
            jMenuFileChangePassword.setEnabled(true);
            result = true;
          } catch(org.jdom.JDOMException je) {
            JOptionPane.showMessageDialog(this, lang.getString("Error loading file: wrong password?"), je.getLocalizedMessage(), JOptionPane.ERROR_MESSAGE);
            tableData.removeAllRows();
          } catch(FileNotFoundException fnfe) {
            showException(fnfe);
//          } catch(IOException ioe) {
//            showException(ioe);
          }//catch
        }//if pass OK
      }//if .jpm
      else if(currentData.getFileType() == Config.FILE_XML) {
        try {
//        loadXML(currentFile);
          tableData.setDataVector(new canne.jpassmate.io.XML().load(currentData.getFile()));
          setModified(true);
          result = true;
        } catch(FileNotFoundException fnfe) {
          showException(fnfe);
//          tableData.removeAllRows();
        } catch(org.jdom.JDOMException je) {
          showException(je);
//          tableData.removeAllRows();
        } catch(IOException ioe) {
          showException(ioe);
        }//catch
      }//if .xml
      else if(currentData.getFileType() == Config.FILE_CSV) {
        try {
//          loadCSV(currentFile);
          tableData.setDataVector(new canne.jpassmate.io.CSV().load(currentData.getFile()));
          setModified(true);
          result = true;
        } catch(canne.jpassmate.io.CSVFormatException cfe) {
          JOptionPane.showMessageDialog(this, "'"+cfe.getMessage()+"'", "Wrong format", JOptionPane.ERROR_MESSAGE);
        } catch(FileNotFoundException fnfe) {
          showException(fnfe);
//          tableData.removeAllRows();
        } catch(IOException ioe) {
          showException(ioe);
//          tableData.removeAllRows();
        }//catch
      }//if .csv
      if(!result) {
        setTitle(buildTitle());
        tblData.setModel(tableData);
        currentData = oldData;
      }
      repaint();
    }//if file OK
//     else {
//       passwordData = oldData;
//     }//if Cancel
    return result;
  }//boolean load()

  void copyToClipboard() {
    int row = tblData.getSelectedRow();
    java.awt.datatransfer.StringSelection ssel = new java.awt.datatransfer.StringSelection(tableData.getValueAt(row, 0)+","+new String((char[])tableData.getValueAt(row, 1))+","+tableData.getValueAt(row, 2)+","+tableData.getValueAt(row, 3));
    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssel, ssel);
  }//public copyToClipboard()

  void cutToClipboard() {
    copyToClipboard();
    removePassword(tblData.getSelectedRow());
  }//public cutToClipboard()

  void pasteFromClipboard() {
    java.awt.datatransfer.Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
    if(t instanceof java.awt.datatransfer.StringSelection && t.isDataFlavorSupported(java.awt.datatransfer.DataFlavor.stringFlavor)) {
      try {
        String data = (String)((java.awt.datatransfer.StringSelection)t).getTransferData(java.awt.datatransfer.DataFlavor.stringFlavor);
        String name, url, notes;
        char[] password;
        int startIndex = 0, endIndex = data.indexOf(',');
        if(endIndex < 0) {
          throw new IOException(lang.getString("Error parsing name"));
        }//if
        name = data.substring(startIndex, endIndex);
        startIndex = endIndex + 1; endIndex = data.indexOf(',', startIndex);
        if(endIndex < 0) {
          throw new IOException(lang.getString("Error parsing password"));
        }//if
        password = data.substring(startIndex, endIndex).toCharArray();
        startIndex = endIndex + 1; endIndex = data.indexOf(',', startIndex);
        if(endIndex < 0) {
          throw new IOException(lang.getString("Error parsing url"));
        }//if
        url = data.substring(startIndex, endIndex);
        startIndex = endIndex + 1;
        notes = data.substring(startIndex);
        tableData.addRow(name, password, url, notes);
        setModified(true);
      } catch(IOException ioe) {
//        ioe.printStackTrace();
        JOptionPane.showMessageDialog(this, lang.getString("Error getting data from the clipboard")+"("+ioe.getLocalizedMessage()+")");
      } catch(java.awt.datatransfer.UnsupportedFlavorException ufe) {
//        ufe.printStackTrace();
        JOptionPane.showMessageDialog(this, lang.getString("No usable data in the clipboard")+"("+ufe.getLocalizedMessage()+")");
      }//catch
    }//if java.awt.datatransfer.StringSelection
    else {
      JOptionPane.showMessageDialog(this, lang.getString("No usable data in the clipboard"));
    }//else
    repaint();
  }//void pasteFromClipboard()

  public void actionPerformed(ActionEvent evt) {
    Object src = evt.getSource();
    if(src == btnSave || src == jMenuFileSave) {
      save();
    }//Save
    else if(src == jMenuFileNew) {
      newTable();
    }//Save
    else if(src == jMenuFileSaveAs) {
      saveAs();
    }//Save
    else if(src == jMenuFileChangePassword) {
      getNewIO();
    }//New Password
    else if (src == btnLoad || src == jMenuFileLoad) {
      load();
    }//Load
    else if(src == jMenuHelpAbout) {
      showAbout();
    }//Help->About
    else if(src == jMenuFileExit) {
      exit(0);
    }//File->Exit
    else if(src == jMenuEditCopy) {
      copyToClipboard();
    }//Edit->Copy
    else if(src == jMenuEditCut) {
      cutToClipboard();
    }//Edit->Cut
    else if(src == jMenuEditPaste) {
      pasteFromClipboard();
    }//Edit->Paste
    else if(src == jMenuEditAdd) {
      addPassword();
    }//Edit->Add...
    else if(src == jMenuEditDelete) {
      removePassword(tblData.getSelectedRow());
    }//Edit->Delete
    else
      JOptionPane.showMessageDialog(this, lang.getString("Option not yet implemented"));
  }//public void actionPerformed(ActionEvent)

  private void showException(Throwable t) {
    String message = null;
    if(t instanceof FileNotFoundException) {
      message = lang.getString("Error (File Not Found)");
    }//if FileNotFoundException
    else if(t instanceof IOException) {
      message = lang.getString("Error (I/O exception)");
    }//if IOException
    else if(t instanceof javax.crypto.NoSuchPaddingException) {
      message = lang.getString("Error (No Such Padding)");
    }//NoSuchPaddingException
    else if(t instanceof java.security.NoSuchAlgorithmException) {
      message = lang.getString("Error (No Such Algorithm)");
    }//NoSuchAlgorithmException
    else if(t instanceof java.security.InvalidKeyException) {
      message = lang.getString("Error (Invalid Key)");
    }//InvalidKeyException
    else if(t instanceof java.security.spec.InvalidKeySpecException) {
      message = lang.getString("Error (Invalid Key Spec)");
    }//InvalidKeySpecException
    else if(t instanceof org.jdom.JDOMException) {
      message = lang.getString("Error (JDOM)");
    }//JDOMException
    else {
      message = lang.getString("Generic Error")+" ("+t.getClass().getName()+")";
    }//else
    JOptionPane.showMessageDialog(this, message, t.getLocalizedMessage(), JOptionPane.ERROR_MESSAGE);
    if(Boolean.getBoolean("DEBUG"))
      t.printStackTrace();
  }//private void showException(Throwable)

/**
 * Exit from the program.
 */
  public void exit(int code) {
    if(code == 0 && modified) {
      int result = JOptionPane.showConfirmDialog(this, lang.getString("Data was modified: save?"));
      if(result == JOptionPane.YES_OPTION) {
//         if(save())
//           System.exit(code);
      }//if YES
      else if(result == JOptionPane.NO_OPTION) {
        System.exit(code);
      }//if NO
      else
        return;
    }//if modified
    else
      System.exit(code);
  }//public void exit(int)

  public void windowClosing(WindowEvent evt) {
    exit(0);
  }//public void windowClosing(WindowEvent)

  public void windowDeactivated(WindowEvent evt) {}
  public void windowActivated(WindowEvent evt) {}
  public void windowDeiconified(WindowEvent evt) {}
  public void windowIconified(WindowEvent evt) {}
  public void windowClosed(WindowEvent evt) {}
  public void windowOpened(WindowEvent evt) {}

  public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
//    System.out.println("value changed: "+evt);
    if(evt.getValueIsAdjusting()) return;
    if(tblData.getSelectedRow() != -1) {
      jMenuEditDelete.setEnabled(true);
      jMenuEditCut.setEnabled(true);
      jMenuEditCopy.setEnabled(true);
      jMenuEditProperties.setEnabled(true);
    }
    else {
      jMenuEditDelete.setEnabled(false);
      jMenuEditCut.setEnabled(false);
      jMenuEditCopy.setEnabled(false);
      jMenuEditProperties.setEnabled(false);
    }//if no row selected
  }//public void tableChanged(javax.swing.event.TableModelEvent)

  public void log(int level, Object message) {
    logger.log(level, message);
  }//void log(int, Object)

}//class Swing
