package canne.jpassmate.io;

import org.jdom.*;
import java.util.Properties;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Title:        Seti@home Manager
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class XMLProperties extends Properties {

  org.jdom.input.SAXBuilder sax = new org.jdom.input.SAXBuilder();
  Document document = null;

  public XMLProperties() {
    super();
  }//Constructor()

  public XMLProperties(Properties defaults) {
    super(defaults);
  }//Constructor(Properties)

  public void load(InputStream inStream) throws java.io.IOException {
    try {
      Element el = (document = sax.build(inStream)).getRootElement();
      for(java.util.Iterator iter = el.getChildren().iterator(); iter.hasNext();) {
        Element next = (Element)iter.next();
        put(next.getName(), next.getText());
      }//for
    } catch(JDOMException je) {
      throw new java.io.IOException(je.getMessage());
    }//catch
  }//public void load(InputStream)

  public void store(OutputStream outStream, String header) throws java.io.IOException {
    org.jdom.output.XMLOutputter sax = new org.jdom.output.XMLOutputter("  ", true);
    Document doc = new Document(new Element(header.replace(' ', '_')));
    for(java.util.Iterator iter = keySet().iterator(); iter.hasNext();) {
      String next = (String)iter.next();
      doc.getRootElement().addContent((new Element(next).setText(getProperty(next))));
    }//for
    sax.output(doc, outStream);
  }//public void store(OutputStream, String)

  void importProperties(Properties prop) {
    this.putAll(prop);
  }//void importProperties(Properties)

  public static XMLProperties properties2XML(Properties prop) {
    XMLProperties result = new XMLProperties();
    result.importProperties(prop);
    return result;
  }//public static XMLProperties properties2XML(Properties)

  public static void properties2XML(InputStream in, OutputStream out, String header) throws java.io.IOException {
    XMLProperties xmlProp = new XMLProperties();
    Properties prop = new Properties();
    prop.load(in);
    XMLProperties.properties2XML(prop).store(out, header);
    out.close();
  }//public static XMLProperties properties2XML(InputStream, OutputStream)

}//class XMLProperties
