package canne.jpassmate.io;

import canne.jpassmate.*;

import java.io.*;
import java.util.Iterator;
import java.util.Vector;

/**
 * XML.java
 *
 *
 * Created: Sun Nov  2 21:05:01 2003
 *
 * @author <a href="mailto:">Nicola Canepa</a>
 * @version 1.0
 */
public class XML extends canne.jpassmate.BaseModule implements IO {

  java.util.List UIs = new Vector(),
   loggers = new Vector();

  public XML() {
  }//Constructor()

  /**
   * Add an <code>UI</code> to the list of <code>UI</code>s which are triggered when needed. 
   * All <code>UI</code>s aren't always triggered: in certain cases (i.e.: askPassword),
   * the first which returns an answer stops the iteration.
   *  
   * @param ui - the <code>UI</code> to add
   */
    public void addUI(UI ui) {
      UIs.add(ui);
    }//public void addUI(UI)

  /**
   * Remove an <code>UI</code> to the list of <code>UI</code>s which are triggered when needed. 
   *  
   * @param ui - the <code>UI</code> to remove
   */
    public void removeUI(UI ui) {
      UIs.remove(ui);
    }//public void removeUI(UI)

    /**
     * Add a <code>logger</code> to the list of <code>Logger</code>s which are triggered when needed. 
     * All <code>logger</code>s are always triggered.
     *  
     * @param logger - the <code>Logger</code> to add
     */
    public void addLogger(Logger logger) {
      loggers.add(logger);
    }//public void addLogger(Logger)

    /**
     * Remove a <code>logger</code> to the list of <code>Logger</code>s which are triggered.
     *  
     * @param logger - the <code>Logger</code> to remove
     */
    public void removeLogger(Logger logger) {
      loggers.remove(logger);
    }//public void removeLogger(Logger)

    void log(int level, Object s) {
      if(loggers.size() > 0) {
  /*// If using java 1.5 uncomment this and comment the next 2 lines
        for(Object ui: loggers) {
        (Logger)logger.log(level, s);
  */
        for(Iterator i = UIs.iterator(); i.hasNext(); ) {
          ((Logger)i.next()).log(level, s);
        }//for
      }//if
    }//log(int, Object)

    char[] askPassword(boolean confirm) {
      char []result = null;
      if(UIs.size() > 0) {
  /*// If using java 1.5 uncomment this and comment the next 2 lines
        for(Object ui: UIs) {
      result = ((UI)ui).askPassword(confirm);
  */
        for(Iterator i = UIs.iterator(); i.hasNext(); ) {
          result = ((UI)i.next()).askPassword(confirm);
          if(result != null)
            return result;
        }//for
      }//if
      return result;
    }//char[] askPassword(boolean)

    void fileLoaded() {
      if(UIs.size() > 0) {
        /*// If using java 1.5 uncomment this and comment the next 2 lines
              for(Object ui: UIs) {
            ((UI)ui).fileLoaded();
        */
              for(Iterator i = UIs.iterator(); i.hasNext(); ) {
                ((UI)i.next()).fileLoaded();
              }//for
            }//if
    }//void fileLoaded()

/**
 * Load a vector of PassMateData (data) from an (unencrypted) XML file
 */
  public Vector load(File file) throws FileNotFoundException, org.jdom.JDOMException, IOException {
    return load(new FileInputStream(file));
  }//public Vector loadXML(File, char[])

/**
 * Load the passwords from the specified <CODE>InputStream</CODE>.
 * The file must be XML, with (inside the root), several "Entry" children, each
 * with "Name", "password", "URL" and "Notes" subchildren.
 */
  public Vector load(InputStream is) throws org.jdom.JDOMException, IOException {
    Vector result = new Vector();
    org.jdom.Document doc = (new org.jdom.input.SAXBuilder().build(is));
    for(java.util.Iterator iter = doc.getRootElement().getChildren().iterator(); iter.hasNext();) {
      org.jdom.Element elem = (org.jdom.Element)iter.next();
      org.jdom.Element element;
      String name = null, url = null, notes = null;
      char[] passwd = null;
      element = elem.getChild("Name");
      if(element != null)
        name = element.getText();
      element = elem.getChild("Password");
      if(element != null)
        passwd = element.getText().toCharArray();
      element = elem.getChild("URL");
      if(element != null)
        url = element.getText();
      element = elem.getChild("Notes");
      if(element != null)
        notes = element.getText();
      result.add(new PassMateData(name, passwd, url, notes));
    }//for
    return result;
  }//Vector load(InputStream)

/**
 * Save the vector of PassMateData (data) to file in (unencrypted) XML format
 */
  public void save(File file, Vector data) throws FileNotFoundException, IOException {
    FileOutputStream fos = new FileOutputStream(file);
    save(fos, data);
  }//void saveXML(File, char[])

/**
 * Write the passwords to the specified <CODE>OutputStream</CODE>.
 * The file will be XML, with (inside the "jPassMate_data" root), several
 * "Entry" children, each with "Name", "password", "URL" and "Notes" subchildren.
 */
  public void save(OutputStream os, Vector data) throws IOException {
    org.jdom.Element rootElement = new org.jdom.Element("jPassMate_data");
    org.jdom.Document doc = new org.jdom.Document(rootElement);
    PassMateData row;
    for(int i = 0; i < data.size(); i++) {
      org.jdom.Element element = new org.jdom.Element("Entry");
      row = (PassMateData)data.elementAt(i);
      if(row.getName() != null)
        element.addContent(new org.jdom.Element("Name").addContent(row.getName()));
      if(row.getPassword() != null)
        element.addContent(new org.jdom.Element("Password").addContent(new String(row.getPassword())));
      if(row.getURL() != null)
        element.addContent(new org.jdom.Element("URL").addContent(row.getURL()));
      if(row.getNotes() != null)
        element.addContent(new org.jdom.Element("Notes").addContent(row.getNotes()));
      rootElement.addContent(element);
    }//for
    (new org.jdom.output.XMLOutputter("  ", true, "ISO-8859-1")).output(doc, os);
    os.close();
  }//void save(OutputStream, Vector)

}//class XML
