package canne.jpassmate.io;

import canne.jpassmate.*;

import java.util.*;
import java.io.*;
import javax.crypto.*;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.PBEKeySpec;

/**
 * Crypto.java
 *
 *
 * Created: Wed Oct 29 19:01:41 2003
 *
 * @author <a href="mailto:">Nicola Canepa</a>
 * @version 1.0
 */
public class Crypto extends BaseModule implements IO {

  private Cipher encryptCipher, decryptCipher;
//  private UI ui;
  private java.util.List UIs = new java.util.Vector(),
   loggers = new java.util.Vector();
//   CipherOutputStream cypherOS;
//   CipherInputStream cipherIS;

  static java.security.Provider provider = null;

/*  public Crypto(char[] password) {
    passwd(password);
  }//Constructor(char[])*/
/**
 * Constructs a Crypto IO, which asks password throught the supplied UI.askPassword(boolean)
 * @param ui the UI used to ask for password, etc.
 */
  public Crypto(UI ui) {
//    ui.log(1, "New Crypto");
    addUI(ui);
//    this.ui = ui;
  }//Constructor(UI)

/**
 * Add an <code>UI</code> to the list of <code>UI</code>s which are triggered when needed. 
 * All <code>UI</code>s aren't always triggered: in certain cases (i.e.: askPassword),
 * the first which returns an answer stops the iteration.
 *  
 * @param ui - the <code>UI</code> to add
 */
  public void addUI(UI ui) {
    UIs.add(ui);
  }//public void addUI(UI)

/**
 * Remove an <code>UI</code> to the list of <code>UI</code>s which are triggered when needed. 
 *  
 * @param ui - the <code>UI</code> to remove
 */
  public void removeUI(UI ui) {
    UIs.remove(ui);
  }//public void removeUI(UI)

  /**
   * Add a <code>logger</code> to the list of <code>Logger</code>s which are triggered when needed. 
   * All <code>logger</code>s are always triggered.
   *  
   * @param logger - the <code>Logger</code> to add
   */
  public void addLogger(Logger logger) {
    loggers.add(logger);
  }//public void addLogger(Logger)

  /**
   * Remove a <code>logger</code> to the list of <code>Logger</code>s which are triggered.
   *  
   * @param logger - the <code>Logger</code> to remove
   */
  public void removeLogger(Logger logger) {
    loggers.remove(logger);
  }//public void removeLogger(Logger)

  void log(int level, Object s) {
    if(loggers.size() > 0) {
/*// If using java 1.5 uncomment this and comment the next 2 lines
      for(Object ui: loggers) {
      (Logger)logger.log(level, s);
*/
      for(Iterator i = loggers.iterator(); i.hasNext(); ) {
        ((Logger)i.next()).log(level, s);
      }//for
    }//if
  }//log(int, Object)

  char[] askPassword(boolean confirm) {
    char []result = null;
    if(UIs.size() > 0) {
/*// If using java 1.5 uncomment this and comment the next 2 lines
      for(Object ui: UIs) {
    result = ((UI)ui).askPassword(confirm);
*/
      for(Iterator i = UIs.iterator(); i.hasNext(); ) {
        result = ((UI)i.next()).askPassword(confirm);
        if(result != null)
          return result;
      }//for
    }//if
    return result;
  }//char[] askPassword(boolean)

  void fileLoaded() {
    if(UIs.size() > 0) {
      /*// If using java 1.5 uncomment this and comment the next 2 lines
            for(Object ui: UIs) {
          ((UI)ui).fileLoaded();
      */
            for(Iterator i = UIs.iterator(); i.hasNext(); ) {
              ((UI)i.next()).fileLoaded();
            }//for
          }//if
  }//void fileLoaded()

  public static Cipher getDecryptCipher(char[] password) {
    if(provider == null)
      java.security.Security.addProvider(provider = new com.sun.crypto.provider.SunJCE());
    return getCipher(Cipher.DECRYPT_MODE, password);
  }//public static Cipher getEncryptCipher(char[])

  private Cipher getDecryptCipher() {
  	if(decryptCipher == null)
  	  passwd(askPassword(false));
	log(3, "Returning decrypt cipher: "+decryptCipher);
  	return decryptCipher;
  }//private Cipher getDecryptCipher()

  public static Cipher getEncryptCipher(char[] password) {
    if(provider == null)
      java.security.Security.addProvider(provider = new com.sun.crypto.provider.SunJCE());
    return getCipher(Cipher.ENCRYPT_MODE, password);
  }//public static Cipher getEncryptCipher(char[])

  private Cipher getEncryptCipher() {
	if(encryptCipher == null)
  	  passwd(askPassword(true));
	log(3, "Returning encrypt cipher: "+encryptCipher);
 	return encryptCipher;
  }//private Cipher getEncryptCipher()

  public Vector load(java.io.File file) throws canne.jpassmate.io.WrongPasswordException, org.jdom.JDOMException, FileNotFoundException, IOException {
    CipherInputStream cis = new CipherInputStream(new FileInputStream(file), getDecryptCipher());
//    java.util.zip.GZIPInputStream gis = null;
    java.io.InputStream gis = null;
    Vector result = null;
    if(decryptCipher != null && file != null) {
      try {
        gis = new java.util.zip.GZIPInputStream(cis);
        fileLoaded();
      } catch(IOException ioe) {
        gis = cis;
//        result = load(cis);
      }//catch
      try {
        result = (new XML()).load(gis);
      } catch(org.jdom.JDOMException je) {
        throw new canne.jpassmate.io.WrongPasswordException();
      }//catch
    }
    return result;
  }//public Vector load(java.io.File)

/*  private Vector load(InputStream is) throws org.jdom.JDOMException, IOException {
    return (new XML()).load(is);
  }//private void save(OutputStream, Vector)
*/
  public void save(java.io.File file, Vector data)  throws FileNotFoundException, IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
    Cipher cipher = getEncryptCipher();
    CipherOutputStream cos;
    if (cipher != null) {
      cos = new CipherOutputStream(new FileOutputStream(file), cipher);
      java.util.zip.GZIPOutputStream gos = new java.util.zip.GZIPOutputStream(cos);
      (new XML()).save(gos, data);
    }//if got password
  }//public void save(java.io.File, Vector)

/*  private void save(OutputStream os, Vector data) throws java.io.IOException {
    (new XML()).save(os, data);
  }//private void save(OutputStream, Vector)
*/
  public void passwd(char[] newPasswd) {
  	if(newPasswd != null) {
      encryptCipher = getEncryptCipher(newPasswd);
      decryptCipher = getDecryptCipher(newPasswd);
  	}//if
  }//public void passwd(char[])

  static Cipher getCipher(int mode, char[] password) {
    Cipher cipher = null;
    if(password != null) {
      try {
        byte[] salt = new byte[] {0, 0, 0, 0, 0, 0, 0, 0};
        PBEKeySpec keySpec = new PBEKeySpec(password);
        cipher = Cipher.getInstance("PBEWithMD5AndDES");
        for(byte i = 0; i < 8 && i < password.length; i++)
          salt[i] = (byte)password[i];
          cipher.init(mode, SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec),
          new javax.crypto.spec.PBEParameterSpec(salt, 3));
        for(byte i = 0; i < 8; i++)
          salt[i] = 0;
      } catch(NoSuchPaddingException nspe) {
        nspe.printStackTrace();
      } catch(java.security.NoSuchAlgorithmException nsae) {
        nsae.printStackTrace();
      } catch(java.security.spec.InvalidKeySpecException ikse) {
        ikse.printStackTrace();
      } catch(java.security.InvalidKeyException ike) {
        ike.printStackTrace();
      } catch(java.security.InvalidAlgorithmParameterException nsae) {
        nsae.printStackTrace();
      }//catch
    }//if
    return cipher;
  }//static Cipher getCipher(int, char[])

  public String toString() {
    return "Provider "+provider+" ("+(encryptCipher == null?"no ":"with ")+"enc, "+(decryptCipher == null?"no ":"with ")+"dec)";
  }//String toString()

}//class Crypto
