package canne.jpassmate.io;

import canne.jpassmate.*;

import java.io.*;
import java.util.*;

/**
 * CSV.java
 *
 *
 * Created: Tue Nov  4 07:03:06 2003
 *
 * @author <a href="mailto:">Nicola Canepa</a>
 * @version 1.0
 */
public class CSV extends canne.jpassmate.BaseModule implements canne.jpassmate.IO {

  java.util.List UIs = new Vector(),
   loggers = new Vector();

  public CSV() {
  }//Constructor()

  /**
   * Add an <code>UI</code> to the list of <code>UI</code>s which are triggered when needed. 
   * All <code>UI</code>s aren't always triggered: in certain cases (i.e.: askPassword),
   * the first which returns an answer stops the iteration.
   *  
   * @param ui - the <code>UI</code> to add
   */
    public void addUI(UI ui) {
      UIs.add(ui);
    }//public void addUI(UI)

  /**
   * Remove an <code>UI</code> to the list of <code>UI</code>s which are triggered when needed. 
   *  
   * @param ui - the <code>UI</code> to remove
   */
  public void removeUI(UI ui) {
    UIs.remove(ui);
  }//public void removeUI(UI)

  /**
   * Add a <code>logger</code> to the list of <code>Logger</code>s which are triggered when needed. 
   * All <code>logger</code>s are always triggered.
   *  
   * @param logger - the <code>Logger</code> to add
   */
  public void addLogger(Logger logger) {
    loggers.add(logger);
  }//public void addLogger(Logger)

  /**
   * Remove a <code>logger</code> to the list of <code>Logger</code>s which are triggered.
   *  
   * @param logger - the <code>Logger</code> to remove
   */
  public void removeLogger(Logger logger) {
    loggers.remove(logger);
  }//public void removeLogger(Logger)

  void log(int level, Object s) {
    if(loggers.size() > 0) {
/*// If using java 1.5 uncomment this and comment the next 2 lines
      for(Object ui: loggers) {
      (Logger)logger.log(level, s);
*/
      for(Iterator i = UIs.iterator(); i.hasNext(); ) {
        ((Logger)i.next()).log(level, s);
      }//for
    }//if
  }//log(int, Object)

/**
 * Load a vector of PassMateData (data) from an (unencrypted) CSV file
 */
  public Vector load(File file) throws FileNotFoundException, IOException, CSVFormatException {
    Vector result = new Vector();
    BufferedReader br = new BufferedReader(new FileReader(file));
    String line = null;
    while((line = br.readLine()) != null) {
      java.util.StringTokenizer st = new java.util.StringTokenizer(line, ",");
      if(st.countTokens() == 4) {
//        notifyDataChange(PassMateEvent.PASS_MATE_PASSWORDS_ADDED, new PassMateData(st.nextToken(), st.nextToken().toCharArray(), st.nextToken(), st.nextToken()));
        result.add(new PassMateData(st.nextToken(), st.nextToken().toCharArray(), st.nextToken(), st.nextToken()));
//        passwordData.addRow(st.nextToken(), st.nextToken().toCharArray(), st.nextToken(), st.nextToken());
      }//if 4 tokens
      else {
        throw new CSVFormatException(line);
//        passwordData.clearTable();
//        return;
      }//else
    }//while
    br.close();
    return result;
  }//public void load(File)

/**
 * Save the vector of PassMateData (data) to file in (unencrypted) CSV format
 */
  public void save(File file, Vector data) throws FileNotFoundException, IOException {
    BufferedWriter bw = new BufferedWriter(new FileWriter(file));
    for(int i = 0; i < data.size(); i++) {
      PassMateData row = (PassMateData)data.elementAt(i);
      bw.write(row.getName()+", "+new String((char[])row.getPassword())+", "+row.getURL()+", "+row.getNotes());
      bw.newLine();
    }//for
    bw.close();
  }//void save(File)

}//class CSV
