package canne.jpassmate;

import canne.jpassmate.io.*;
/*import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.PBEKeySpec;*/

/**
 * Title:        Java PassMate
 * Description:  Application to store encrypted passwords
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author Canne
 * @version 1.0
 */

public class Config {

  private final static String CONFIG_FILE = "jPassMate.cfg";
  public final static String BASE = "jPassMate";
  public final static String LOCALE = BASE+".Locale",
    CIPHER = BASE+".CryptAlgorithm";
  public final static byte FILE_NONE = -1,
    FILE_JPM = 1,
    FILE_XML = 2,
    FILE_CSV = 3,
    NAME_COLUMN = 0,
    PASSWORD_COLUMN = 1,
    URL_COLUMN = 2,
    NOTES_COLUMN = 3;

  static XMLProperties config;
  boolean alwaysSave = false;
  static java.security.Provider provider = null;

  public Config() {
  }//Constructor()

  static XMLProperties getConfig() throws java.io.IOException {
    if(config == null) {
      config = new XMLProperties(new DefaultConfig());
      try {
        config.load(new java.util.zip.GZIPInputStream(new java.io.FileInputStream(CONFIG_FILE)));
      } catch(java.io.FileNotFoundException fnfe) {
        save();
//        fnfe.printStackTrace();
/*      } catch(java.io.IOException ioe) {
        ioe.printStackTrace();*/
      }//catch
    }//if
    return config;
  }//static XMLProperties getConfig()

  public static String getLocalization() {
    try {
      return getConfig().getProperty(LOCALE);
    } catch(java.io.IOException ioe) {
      ioe.printStackTrace();
    }//catch
    return null;
  }//public static String getLocalozation()

  public static void save() throws java.io.FileNotFoundException, java.io.IOException {
    java.util.zip.GZIPOutputStream os = new java.util.zip.GZIPOutputStream(new java.io.FileOutputStream(CONFIG_FILE));
    getConfig().store(os, "jPassMate configuration file");
    os.close();
  }//public static void save()

}//class Config
