/*
 * Decompiled with CFR 0.152.
 */
package canne.jpassmate.ui;

import canne.jpassmate.IO;
import canne.jpassmate.Logger;
import canne.jpassmate.UI;
import canne.jpassmate.io.CSV;
import canne.jpassmate.io.CSVFormatException;
import canne.jpassmate.io.Crypto;
import canne.jpassmate.io.FileFilterWithDescription;
import canne.jpassmate.io.WrongPasswordException;
import canne.jpassmate.io.XML;
import canne.jpassmate.logger.Stderr;
import canne.jpassmate.ui.Localization;
import canne.jpassmate.ui.Swing_AboutBox;
import canne.jpassmate.ui.TableModel;
import canne.jpassmate.ui.jpmTableCellEditor;
import canne.jpassmate.ui.jpmTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.JDOMException;

public class Swing
extends JFrame
implements UI,
ActionListener,
WindowListener,
ListSelectionListener,
Localization {
    String[] argv = null;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu(lang.getString("File"));
    JMenu jMenuEdit = new JMenu(lang.getString("Edit"));
    JMenu jMenuHelp = new JMenu(lang.getString("Help"));
    JMenuItem jMenuFileNew = new JMenuItem(lang.getString("New"));
    JMenuItem jMenuFileLoad = new JMenuItem(lang.getString("Open") + "...");
    JMenuItem jMenuFileSave = new JMenuItem(lang.getString("Save"));
    JMenuItem jMenuFileSaveAs = new JMenuItem(lang.getString("Save as") + "...");
    JMenuItem jMenuFileChangePassword = new JMenuItem(lang.getString("Change Password") + "...");
    JMenuItem jMenuFileExit = new JMenuItem(lang.getString("Exit"));
    JMenuItem jMenuEditAdd = new JMenuItem(lang.getString("Add") + "...");
    JMenuItem jMenuEditDelete = new JMenuItem(lang.getString("Delete"));
    JMenuItem jMenuEditCut = new JMenuItem(lang.getString("Cut"));
    JMenuItem jMenuEditCopy = new JMenuItem(lang.getString("Copy"));
    JMenuItem jMenuEditPaste = new JMenuItem(lang.getString("Paste"));
    JMenuItem jMenuEditLaunchurl = new JMenuItem(lang.getString("Launch URL"));
    JMenuItem jMenuEditSearch = new JMenuItem(lang.getString("Search"));
    JMenuItem jMenuEditProperties = new JMenuItem(lang.getString("Properties") + "...");
    JMenuItem jMenuHelpAbout = new JMenuItem(lang.getString("About"));
    JToolBar jToolBar = new JToolBar();
    JButton btnLoad = new JButton(lang.getString("Open"));
    JButton btnSave = new JButton(lang.getString("Save"));
    JButton btnHelp = new JButton(lang.getString("Help"));
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    TitledBorder titledBorder1;
    JFileChooser fileChooser = null;
    FileFilterWithDescription fileFilterJPM;
    FileFilterWithDescription fileFilterXML;
    FileFilterWithDescription fileFilterCSV;
    static final String TITLE = "jPassMate";
    private TableModel tableData = new TableModel();
    JTable tblData = new JTable(this.tableData);
    boolean modified = false;
    byte currentFileType = (byte)-1;
    File currentFile = null;
    IO io;
    Logger logger;

    public Swing(String[] stringArray) {
        this.argv = stringArray;
    }

    public void setParam(String string, Object object) {
    }

    public Object getParam(String string) {
        return null;
    }

    public void startUI() {
        this.logger = new Stderr();
        if (Boolean.getBoolean("DEBUG")) {
            this.logger.setLevel((byte)10);
        }
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder1 = new TitledBorder("");
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(400, 300));
        this.setTitle(TITLE);
        this.statusBar.setText(" ");
        this.jMenuEditDelete.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.jMenuEditCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuEditPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuFileNew.addActionListener(this);
        this.jMenuFileLoad.addActionListener(this);
        this.jMenuFileSave.addActionListener(this);
        this.jMenuFileSaveAs.addActionListener(this);
        this.jMenuFileChangePassword.addActionListener(this);
        this.jMenuFileExit.addActionListener(this);
        this.jMenuEditAdd.addActionListener(this);
        this.jMenuEditDelete.addActionListener(this);
        this.jMenuEditCut.addActionListener(this);
        this.jMenuEditCopy.addActionListener(this);
        this.jMenuEditPaste.addActionListener(this);
        this.jMenuEditLaunchurl.addActionListener(this);
        this.jMenuEditSearch.addActionListener(this);
        this.jMenuEditProperties.addActionListener(this);
        this.jMenuHelpAbout.addActionListener(this);
        this.btnLoad.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.tblData.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jToolBar.add(this.btnLoad);
        this.jToolBar.add(this.btnSave);
        this.jToolBar.add(this.btnHelp);
        this.jMenuFileChangePassword.setEnabled(false);
        this.jMenuEditDelete.setEnabled(false);
        this.jMenuEditCut.setEnabled(false);
        this.jMenuEditCopy.setEnabled(false);
        this.jMenuEditPaste.setEnabled(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) instanceof StringSelection);
        this.jMenuEditLaunchurl.setEnabled(false);
        this.jMenuEditSearch.setEnabled(false);
        this.jMenuEditProperties.setEnabled(false);
        this.jMenuFile.add(this.jMenuFileNew);
        this.jMenuFile.add(this.jMenuFileLoad);
        this.jMenuFile.add(this.jMenuFileSave);
        this.jMenuFile.add(this.jMenuFileSaveAs);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileChangePassword);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuEdit.add(this.jMenuEditAdd);
        this.jMenuEdit.add(this.jMenuEditDelete);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuEditCut);
        this.jMenuEdit.add(this.jMenuEditCopy);
        this.jMenuEdit.add(this.jMenuEditPaste);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuEditLaunchurl);
        this.jMenuEdit.add(this.jMenuEditSearch);
        this.jMenuEdit.add(this.jMenuEditProperties);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.tblData.setDefaultRenderer(new char[0].getClass(), new jpmTableCellRenderer());
        this.tblData.setDefaultEditor(new char[0].getClass(), new jpmTableCellEditor());
        this.tblData.getSelectionModel().addListSelectionListener(this);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)new JScrollPane(this.tblData), "Center");
        this.addWindowListener(this);
        this.logger.log(3, (Object)("About to start GUI: " + this + " {" + this.contentPane + "}"));
        if (this.argv.length > 0 && !this.argv[0].startsWith("-")) {
            try {
                this.load(new File(this.argv[0]));
            }
            catch (JDOMException jDOMException) {
                jDOMException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        this.setVisible(true);
    }

    public IO getIO() {
        if (this.io == null) {
            this.log(1, "New Crypto");
            this.io = new Crypto(this);
            this.io.addLogger(this.logger);
        }
        this.logger.log(8, (Object)("Returning IO: " + this.io));
        return this.io;
    }

    public IO getNewIO() {
        IO iO = this.io;
        this.io = null;
        this.io = this.getIO();
        if (this.io == null) {
            this.io = iO;
            return null;
        }
        return this.io;
    }

    public IO clearIO() {
        IO iO = this.io;
        this.logger.log(8, (Object)("Clearing IO " + this.io));
        this.io = null;
        return iO;
    }

    public IO setIO(IO iO) {
        IO iO2 = this.io;
        this.io = iO;
        return iO2;
    }

    char[] askPassword() {
        return this.askPassword(false);
    }

    public char[] askPassword(boolean bl) {
        JPasswordField jPasswordField = new JPasswordField();
        char[] cArray = null;
        this.logger.log(8, (Object)"Asking new password");
        if (bl) {
            JPasswordField jPasswordField2 = new JPasswordField();
            if (JOptionPane.showConfirmDialog(this, new Object[]{jPasswordField, jPasswordField2}, lang.getString("Insert password"), 2) == 0) {
                if (new String(jPasswordField.getPassword()).equals(new String(jPasswordField2.getPassword()))) {
                    cArray = jPasswordField.getPassword();
                } else {
                    JOptionPane.showMessageDialog(this, lang.getString("Passwords do not match"));
                }
            }
        } else if (JOptionPane.showConfirmDialog(this, new Object[]{jPasswordField}, lang.getString("Insert password"), 2) == 0) {
            cArray = jPasswordField.getPassword();
        }
        this.logger.log(2, (Object)("Returning password: " + (cArray != null ? "XXXXXX" : "null")));
        return cArray;
    }

    public void fileLoaded() {
        this.setModified(false);
    }

    void load(File file) throws JDOMException, FileNotFoundException {
        boolean bl = false;
        Vector vector = null;
        while (!bl && this.getNewIO() != null) {
            try {
                vector = this.getIO().load(file);
                if (vector == null) continue;
                bl = true;
                this.tableData.setDataVector(vector);
                this.logger.log((byte)2, (Object)("Loaded data file: " + vector.elementAt(0)));
            }
            catch (WrongPasswordException wrongPasswordException) {
                this.logger.log(8, (Object)("Wrong password for file " + file));
                bl = JOptionPane.showConfirmDialog(this, lang.getString("Wrong password: retry?"), lang.getString("Retry?"), 0) == 1;
                this.logger.log(8, (Object)("Cancel password: " + bl));
            }
            catch (JDOMException jDOMException) {
                throw jDOMException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
        }
    }

    void save(File file) {
        Vector vector = new Vector();
        if (this.getIO() != null) {
            try {
                this.getIO().save(file, vector);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void addPassword() {
        JTextField jTextField = new JTextField();
        JTextField jTextField2 = new JTextField();
        JPasswordField jPasswordField = new JPasswordField();
        String string = JOptionPane.showInputDialog(this, new Object[]{new JLabel(lang.getString("Name")), jTextField, new JLabel(lang.getString("Password")), jPasswordField, new JLabel(lang.getString("URL")), jTextField2, new JLabel(lang.getString("Notes"))}, lang.getString("Add") + "...", -1);
        if (string != null) {
            this.tableData.addRow(jTextField.getText(), jPasswordField.getPassword(), jTextField2.getText(), string);
        }
        this.setModified(true);
        this.repaint();
    }

    void removePassword(int n) {
        this.tableData.removeRow(n);
        this.setModified(true);
        this.repaint();
    }

    public void showAbout() {
        Swing_AboutBox swing_AboutBox = new Swing_AboutBox(this);
        Dimension dimension = swing_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        swing_AboutBox.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        swing_AboutBox.setModal(true);
        swing_AboutBox.setVisible(true);
    }

    void setModified(boolean bl) {
        if (bl && !this.modified) {
            this.setTitle(this.getTitle() + " *");
        } else if (!bl && this.modified) {
            this.setTitle(this.getTitle().substring(0, this.getTitle().length() - 2));
        }
        this.modified = bl;
    }

    String buildTitle() {
        return (this.currentFile != null ? this.currentFile.getName() + " - " : "") + TITLE + (this.modified ? " *" : "");
    }

    private File getPasswordFile(int n) {
        File file;
        if (this.currentFile == null && (file = this.selectFile(n)) != null) {
            if (this.fileChooser.getFileFilter() == this.fileFilterJPM) {
                if (!file.exists() && !file.getName().toLowerCase().endsWith(".jpm")) {
                    file = new File(file.getAbsolutePath() + ".jpm");
                }
                this.currentFileType = 1;
            } else if (this.fileChooser.getFileFilter() == this.fileFilterXML) {
                if (!file.exists() && !file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
                this.currentFileType = (byte)2;
            } else if (this.fileChooser.getFileFilter() == this.fileFilterCSV) {
                if (!file.exists() && !file.getName().toLowerCase().endsWith(".csv")) {
                    file = new File(file.getAbsolutePath() + ".csv");
                }
                this.currentFileType = (byte)3;
            }
            this.currentFile = file;
        }
        return this.currentFile;
    }

    File selectFile(int n) {
        return this.selectFile(n, new File("."));
    }

    File selectFile(int n, File file) {
        File file2 = null;
        int n2 = -1;
        if (this.fileChooser == null) {
            this.fileFilterJPM = new FileFilterWithDescription();
            this.fileFilterXML = new FileFilterWithDescription();
            this.fileFilterCSV = new FileFilterWithDescription();
            this.fileChooser = new JFileChooser(file);
            this.fileFilterJPM.addExtension("jpm");
            this.fileFilterJPM.setDescription(lang.getString("jPassMate files"));
            this.fileFilterXML.addExtension("xml");
            this.fileFilterXML.setDescription(lang.getString("Unencrypted XML files"));
            this.fileFilterCSV.addExtension("csv");
            this.fileFilterCSV.addExtension("txt");
            this.fileFilterCSV.setDescription(lang.getString("Unencrypted CSV files"));
            this.fileChooser.addChoosableFileFilter(this.fileFilterJPM);
            this.fileChooser.addChoosableFileFilter(this.fileFilterCSV);
            this.fileChooser.addChoosableFileFilter(this.fileFilterXML);
            this.fileChooser.setFileFilter(this.fileFilterJPM);
        }
        switch (n) {
            case 1: {
                n2 = this.fileChooser.showOpenDialog(this);
                break;
            }
            case 2: {
                n2 = this.fileChooser.showSaveDialog(this);
            }
        }
        if (n2 == 0) {
            file2 = this.fileChooser.getSelectedFile();
        }
        return file2;
    }

    void newTable() {
        boolean bl = true;
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog(this, lang.getString("Data was modified: save?"));
            switch (n) {
                case 0: {
                    this.save();
                    this.tableData.removeAllRows();
                    break;
                }
                case 1: {
                    this.tableData.removeAllRows();
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        if (bl) {
            this.tableData.removeAllRows();
            this.setTitle(this.buildTitle());
        }
    }

    private void saveAs() {
        File file = this.currentFile;
        IO iO = this.clearIO();
        this.currentFile = null;
        this.save();
        if (this.currentFile == null) {
            this.setIO(iO);
        } else {
            iO = null;
            this.setTitle(this.buildTitle());
        }
    }

    private boolean save() {
        boolean bl = false;
        if (this.getPasswordFile(2) != null) {
            if (this.currentFileType == 1) {
                try {
                    this.getIO().save(this.currentFile, this.tableData.getDataVector());
                    this.setModified(false);
                    bl = true;
                }
                catch (NoSuchPaddingException noSuchPaddingException) {
                    this.showException(noSuchPaddingException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.showException(noSuchAlgorithmException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    this.showException(invalidKeyException);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    this.showException(invalidKeySpecException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.showException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    this.showException(iOException);
                }
                catch (Exception exception) {
                    this.showException(exception);
                }
            } else if (JOptionPane.showConfirmDialog(this, lang.getString("Warning: saving unencrypted data!")) == 0) {
                try {
                    this.getIO().save(this.currentFile, this.tableData.getDataVector());
                    bl = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.showException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    this.showException(iOException);
                }
                catch (Exception exception) {
                    this.showException(exception);
                }
            }
        }
        return bl;
    }

    boolean load() {
        boolean bl = false;
        byte by = this.currentFileType;
        File file = this.currentFile;
        this.currentFile = null;
        if (this.getPasswordFile(1) != null) {
            if (this.currentFileType == 1) {
                if (this.getNewIO() != null) {
                    try {
                        this.load(this.currentFile);
                        this.setModified(false);
                        this.jMenuFileChangePassword.setEnabled(true);
                        bl = true;
                    }
                    catch (JDOMException jDOMException) {
                        JOptionPane.showMessageDialog(this, lang.getString("Error loading file: wrong password?"), jDOMException.getLocalizedMessage(), 0);
                        this.tableData.removeAllRows();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.showException(fileNotFoundException);
                    }
                }
            } else if (this.currentFileType == 2) {
                try {
                    this.tableData.setDataVector(new XML().load(this.currentFile));
                    this.setModified(true);
                    bl = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.showException(fileNotFoundException);
                }
                catch (JDOMException jDOMException) {
                    this.showException(jDOMException);
                }
                catch (IOException iOException) {
                    this.showException(iOException);
                }
            } else if (this.currentFileType == 3) {
                try {
                    this.tableData.setDataVector(new CSV().load(this.currentFile));
                    this.setModified(true);
                    bl = true;
                }
                catch (CSVFormatException cSVFormatException) {
                    JOptionPane.showMessageDialog(this, "'" + cSVFormatException.getMessage() + "'", "Wrong format", 0);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.showException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    this.showException(iOException);
                }
            }
            if (!bl) {
                this.setTitle(this.buildTitle());
                this.tblData.setModel(this.tableData);
                this.currentFileType = by;
                this.currentFile = file;
            }
            this.repaint();
        }
        return bl;
    }

    void copyToClipboard() {
        int n = this.tblData.getSelectedRow();
        StringSelection stringSelection = new StringSelection(this.tableData.getValueAt(n, 0) + "," + new String((char[])this.tableData.getValueAt(n, 1)) + "," + this.tableData.getValueAt(n, 2) + "," + this.tableData.getValueAt(n, 3));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    void cutToClipboard() {
        this.copyToClipboard();
        this.removePassword(this.tblData.getSelectedRow());
    }

    void pasteFromClipboard() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        if (transferable instanceof StringSelection && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)((StringSelection)transferable).getTransferData(DataFlavor.stringFlavor);
                int n = 0;
                int n2 = string.indexOf(44);
                if (n2 < 0) {
                    throw new IOException(lang.getString("Error parsing name"));
                }
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                if ((n2 = string.indexOf(44, n)) < 0) {
                    throw new IOException(lang.getString("Error parsing password"));
                }
                char[] cArray = string.substring(n, n2).toCharArray();
                n = n2 + 1;
                if ((n2 = string.indexOf(44, n)) < 0) {
                    throw new IOException(lang.getString("Error parsing url"));
                }
                String string3 = string.substring(n, n2);
                n = n2 + 1;
                String string4 = string.substring(n);
                this.tableData.addRow(string2, cArray, string3, string4);
                this.setModified(true);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, lang.getString("Error getting data from the clipboard") + "(" + iOException.getLocalizedMessage() + ")");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                JOptionPane.showMessageDialog(this, lang.getString("No usable data in the clipboard") + "(" + unsupportedFlavorException.getLocalizedMessage() + ")");
            }
        } else {
            JOptionPane.showMessageDialog(this, lang.getString("No usable data in the clipboard"));
        }
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnSave || object == this.jMenuFileSave) {
            this.save();
        } else if (object == this.jMenuFileNew) {
            this.newTable();
        } else if (object == this.jMenuFileSaveAs) {
            this.saveAs();
        } else if (object == this.jMenuFileChangePassword) {
            this.getNewIO();
        } else if (object == this.btnLoad || object == this.jMenuFileLoad) {
            this.load();
        } else if (object == this.jMenuHelpAbout) {
            this.showAbout();
        } else if (object == this.jMenuFileExit) {
            this.exit(0);
        } else if (object == this.jMenuEditCopy) {
            this.copyToClipboard();
        } else if (object == this.jMenuEditCut) {
            this.cutToClipboard();
        } else if (object == this.jMenuEditPaste) {
            this.pasteFromClipboard();
        } else if (object == this.jMenuEditAdd) {
            this.addPassword();
        } else if (object == this.jMenuEditDelete) {
            this.removePassword(this.tblData.getSelectedRow());
        } else {
            JOptionPane.showMessageDialog(this, lang.getString("Option not yet implemented"));
        }
    }

    private void showException(Throwable throwable) {
        String string = null;
        string = throwable instanceof FileNotFoundException ? lang.getString("Error (File Not Found)") : (throwable instanceof IOException ? lang.getString("Error (I/O exception)") : (throwable instanceof NoSuchPaddingException ? lang.getString("Error (No Such Padding)") : (throwable instanceof NoSuchAlgorithmException ? lang.getString("Error (No Such Algorithm)") : (throwable instanceof InvalidKeyException ? lang.getString("Error (Invalid Key)") : (throwable instanceof InvalidKeySpecException ? lang.getString("Error (Invalid Key Spec)") : (throwable instanceof JDOMException ? lang.getString("Error (JDOM)") : lang.getString("Generic Error") + " (" + throwable.getClass().getName() + ")"))))));
        JOptionPane.showMessageDialog(this, string, throwable.getLocalizedMessage(), 0);
        if (Boolean.getBoolean("DEBUG")) {
            throwable.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exit(int n) {
        if (n == 0 && this.modified) {
            int n2 = JOptionPane.showConfirmDialog(this, lang.getString("Data was modified: save?"));
            if (n2 == 0) return;
            if (n2 != 1) return;
            System.exit(n);
            return;
        } else {
            System.exit(n);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.tblData.getSelectedRow() != -1) {
            this.jMenuEditDelete.setEnabled(true);
            this.jMenuEditCut.setEnabled(true);
            this.jMenuEditCopy.setEnabled(true);
            this.jMenuEditProperties.setEnabled(true);
        } else {
            this.jMenuEditDelete.setEnabled(false);
            this.jMenuEditCut.setEnabled(false);
            this.jMenuEditCopy.setEnabled(false);
            this.jMenuEditProperties.setEnabled(false);
        }
    }

    public void log(int n, Object object) {
        this.logger.log(n, object);
    }
}

