/*
 * Decompiled with CFR 0.152.
 */
package canne.jpassmate.io;

import canne.jpassmate.BaseModule;
import canne.jpassmate.IO;
import canne.jpassmate.Logger;
import canne.jpassmate.UI;
import canne.jpassmate.io.WrongPasswordException;
import canne.jpassmate.io.XML;
import com.sun.crypto.provider.SunJCE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jdom.JDOMException;

public class Crypto
extends BaseModule
implements IO {
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private List UIs = new Vector();
    private List loggers = new Vector();
    static Provider provider = null;

    public Crypto(UI uI) {
        this.addUI(uI);
    }

    public void addUI(UI uI) {
        this.UIs.add(uI);
    }

    public void removeUI(UI uI) {
        this.UIs.remove(uI);
    }

    public void addLogger(Logger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(Logger logger) {
        this.loggers.remove(logger);
    }

    void log(int n, Object object) {
        if (this.loggers.size() > 0) {
            Iterator iterator = this.loggers.iterator();
            while (iterator.hasNext()) {
                ((Logger)iterator.next()).log(n, object);
            }
        }
    }

    char[] askPassword(boolean bl) {
        char[] cArray = null;
        if (this.UIs.size() > 0) {
            Iterator iterator = this.UIs.iterator();
            while (iterator.hasNext()) {
                cArray = ((UI)iterator.next()).askPassword(bl);
                if (cArray == null) continue;
                return cArray;
            }
        }
        return cArray;
    }

    void fileLoaded() {
        if (this.UIs.size() > 0) {
            Iterator iterator = this.UIs.iterator();
            while (iterator.hasNext()) {
                ((UI)iterator.next()).fileLoaded();
            }
        }
    }

    public static Cipher getDecryptCipher(char[] cArray) {
        if (provider == null) {
            provider = new SunJCE();
            Security.addProvider(provider);
        }
        return Crypto.getCipher(2, cArray);
    }

    private Cipher getDecryptCipher() {
        if (this.decryptCipher == null) {
            this.passwd(this.askPassword(false));
        }
        this.log(3, "Returning decrypt cipher: " + this.decryptCipher);
        return this.decryptCipher;
    }

    public static Cipher getEncryptCipher(char[] cArray) {
        if (provider == null) {
            provider = new SunJCE();
            Security.addProvider(provider);
        }
        return Crypto.getCipher(1, cArray);
    }

    private Cipher getEncryptCipher() {
        if (this.encryptCipher == null) {
            this.passwd(this.askPassword(true));
        }
        this.log(3, "Returning encrypt cipher: " + this.encryptCipher);
        return this.encryptCipher;
    }

    public Vector load(File file) throws WrongPasswordException, JDOMException, FileNotFoundException, IOException {
        CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(file), this.getDecryptCipher());
        FilterInputStream filterInputStream = null;
        Vector vector = null;
        if (this.decryptCipher != null && file != null) {
            try {
                filterInputStream = new GZIPInputStream(cipherInputStream);
                this.fileLoaded();
            }
            catch (IOException iOException) {
                filterInputStream = cipherInputStream;
            }
            try {
                vector = new XML().load(filterInputStream);
            }
            catch (JDOMException jDOMException) {
                throw new WrongPasswordException();
            }
        }
        return vector;
    }

    public void save(File file, Vector vector) throws FileNotFoundException, IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        Cipher cipher = this.getEncryptCipher();
        if (cipher != null) {
            CipherOutputStream cipherOutputStream = new CipherOutputStream(new FileOutputStream(file), cipher);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(cipherOutputStream);
            new XML().save(gZIPOutputStream, vector);
        }
    }

    public void passwd(char[] cArray) {
        if (cArray != null) {
            this.encryptCipher = Crypto.getEncryptCipher(cArray);
            this.decryptCipher = Crypto.getDecryptCipher(cArray);
        }
    }

    static Cipher getCipher(int n, char[] cArray) {
        Cipher cipher = null;
        if (cArray != null) {
            try {
                int n2;
                byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                cipher = Cipher.getInstance("PBEWithMD5AndDES");
                for (n2 = 0; n2 < 8 && n2 < cArray.length; n2 = (int)((byte)(n2 + 1))) {
                    byArray[n2] = (byte)cArray[n2];
                }
                cipher.init(n, (Key)SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec), new PBEParameterSpec(byArray, 3));
                for (n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
                    byArray[n2] = 0;
                }
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                noSuchPaddingException.printStackTrace();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                invalidKeySpecException.printStackTrace();
            }
            catch (InvalidKeyException invalidKeyException) {
                invalidKeyException.printStackTrace();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                invalidAlgorithmParameterException.printStackTrace();
            }
        }
        return cipher;
    }

    public String toString() {
        return "Provider " + provider + " (" + (this.encryptCipher == null ? "no " : "with ") + "enc, " + (this.decryptCipher == null ? "no " : "with ") + "dec)";
    }
}

