/*
 * Decompiled with CFR 0.152.
 */
package canne.jpassmate.io;

import canne.jpassmate.BaseModule;
import canne.jpassmate.IO;
import canne.jpassmate.Logger;
import canne.jpassmate.PassMateData;
import canne.jpassmate.UI;
import canne.jpassmate.io.CSVFormatException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class CSV
extends BaseModule
implements IO {
    List UIs = new Vector();
    List loggers = new Vector();

    public void addUI(UI uI) {
        this.UIs.add(uI);
    }

    public void removeUI(UI uI) {
        this.UIs.remove(uI);
    }

    public void addLogger(Logger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(Logger logger) {
        this.loggers.remove(logger);
    }

    void log(int n, Object object) {
        if (this.loggers.size() > 0) {
            Iterator iterator = this.UIs.iterator();
            while (iterator.hasNext()) {
                ((Logger)iterator.next()).log(n, object);
            }
        }
    }

    public Vector load(File file) throws FileNotFoundException, IOException, CSVFormatException {
        Vector<PassMateData> vector = new Vector<PassMateData>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() == 4) {
                vector.add(new PassMateData(stringTokenizer.nextToken(), stringTokenizer.nextToken().toCharArray(), stringTokenizer.nextToken(), stringTokenizer.nextToken()));
                continue;
            }
            throw new CSVFormatException(string);
        }
        bufferedReader.close();
        return vector;
    }

    public void save(File file, Vector vector) throws FileNotFoundException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        for (int i = 0; i < vector.size(); ++i) {
            PassMateData passMateData = (PassMateData)vector.elementAt(i);
            bufferedWriter.write(passMateData.getName() + ", " + new String(passMateData.getPassword()) + ", " + passMateData.getURL() + ", " + passMateData.getNotes());
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }
}

