/*
 * Decompiled with CFR 0.152.
 */
package canne.jpassmate;

import canne.jpassmate.DefaultConfig;
import canne.jpassmate.io.XMLProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Provider;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Config {
    private static final String CONFIG_FILE = "jPassMate.cfg";
    public static final String BASE = "jPassMate";
    public static final String LOCALE = "jPassMate.Locale";
    public static final String CIPHER = "jPassMate.CryptAlgorithm";
    public static final byte FILE_NONE = -1;
    public static final byte FILE_JPM = 1;
    public static final byte FILE_XML = 2;
    public static final byte FILE_CSV = 3;
    public static final byte NAME_COLUMN = 0;
    public static final byte PASSWORD_COLUMN = 1;
    public static final byte URL_COLUMN = 2;
    public static final byte NOTES_COLUMN = 3;
    static XMLProperties config;
    boolean alwaysSave = false;
    static Provider provider;

    static XMLProperties getConfig() throws IOException {
        if (config == null) {
            config = new XMLProperties(new DefaultConfig());
            try {
                config.load(new GZIPInputStream(new FileInputStream(CONFIG_FILE)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Config.save();
            }
        }
        return config;
    }

    public static String getLocalization() {
        try {
            return Config.getConfig().getProperty(LOCALE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void save() throws FileNotFoundException, IOException {
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(CONFIG_FILE));
        Config.getConfig().store(gZIPOutputStream, "jPassMate configuration file");
        gZIPOutputStream.close();
    }

    static {
        provider = null;
    }
}

