package setimanager.percent;

import java.awt.*;
import com.klg.jclass.swing.gauge.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;

/**
 * Title:        Seti@home Manager
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class JCConfigure extends JComponent implements ActionListener {
  BorderLayout borderLayout1 = new BorderLayout();
  JCCircularGaugeBean percentExample = new JCCircularGaugeBean();
  JPanel jPanel1 = new JPanel();
  GridLayout gridLayout1 = new GridLayout(0, 2);
  JLabel jLabel1 = new JLabel();
  JComboBox lstGaugeType = new JComboBox();
  JLabel jLabel2 = new JLabel();
  JComboBox lstNeedleStyle = new JComboBox();
  JLabel jLabel3 = new JLabel();
  JComboBox lstTickStyle = new JComboBox();
//  BorderLayout borderLayout2 = new BorderLayout();

  java.util.Properties configuration = null;
  String gaugeTypes[] = new String[] {"Full circle", "Top half circle", "Bottom half circle",
      "Left half circle", "Right half circle", "Upper right quarter circle", "Lower right quarter circle",
      "Upper left quarter circle", "Lower left quarter circle"},
    needleStyles[] = new String[] {"Tailed Pointer", "Pointer", "Tailed Arrow", "Arrow", "Triangle"},
    tickStyles[] = new String[] {"Diamond", "Triangle", "Reverse Triangle", "Rectangle", "Line", "Circle"};

  public JCConfigure() {
    try {
      jbInit();
    } catch(Exception e) {
      e.printStackTrace();
    }//catch
  }//Constructor()

  private void jbInit() throws Exception {
    jPanel1.setLayout(gridLayout1);
    jLabel1.setLabelFor(lstGaugeType);
    jLabel1.setText("Gauge Type");
    jLabel2.setLabelFor(lstNeedleStyle);
    jLabel2.setText("Needle Style");
    gridLayout1.setColumns(2);
    gridLayout1.setRows(0);
    percentExample.setNeedleStyle(com.klg.jclass.swing.gauge.beans.JCCircularGaugeBean.NEEDLE_TRIANGLE);
    percentExample.setNeedleValue(74.77);
    percentExample.setType(com.klg.jclass.swing.gauge.beans.JCCircularGaugeBean.TYPE_TOP_HALF_CIRCLE);
    jLabel3.setLabelFor(lstTickStyle);
    jLabel3.setText("Tick Style");
    lstGaugeType.addActionListener(this/*new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        lstGaugeType_actionPerformed(e);
      }
    }*/);
    setLayout(borderLayout1);
    lstNeedleStyle.addActionListener(this/*new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        lstNeedleStyle_actionPerformed(e);
      }
    }*/);
    lstTickStyle.addActionListener(this/*new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        lstTickStyle_actionPerformed(e);
      }
    }*/);
    add(jPanel1, BorderLayout.NORTH);
    add(percentExample, BorderLayout.CENTER);
    jPanel1.add(jLabel1, null);
    for(int i = 0; i < gaugeTypes.length; i++)
      lstGaugeType.addItem(gaugeTypes[i]);
    jPanel1.add(lstGaugeType, null);
    jPanel1.add(jLabel2, null);
    for(int i = 0; i < needleStyles.length; i++)
      lstNeedleStyle.addItem(needleStyles[i]);
    jPanel1.add(lstNeedleStyle, null);
    jPanel1.add(jLabel3, null);
    jPanel1.add(lstTickStyle, null);
    for(int i = 0; i < tickStyles.length; i++)
      lstTickStyle.addItem(tickStyles[i]);

//    pack();
  }//private void jbInit()

  public void setConfiguration(java.util.Properties newConfiguration) {
    configuration = newConfiguration;
    lstGaugeType.setSelectedIndex(Integer.parseInt(configuration.getProperty(JCConstants.GAUGE_TYPE, JCDefaults.GAUGE_TYPE)));
    lstNeedleStyle.setSelectedIndex(Integer.parseInt(configuration.getProperty(JCConstants.NEEDLE_STYLE, JCDefaults.NEEDLE_STYLE)));
    lstTickStyle.setSelectedIndex(Integer.parseInt(configuration.getProperty(JCConstants.TICK_STYLE, JCDefaults.TICK_STYLE)));
  }//public void setConfiguration(java.util.Properties)

/*  void lstGaugeType_actionPerformed(ActionEvent e) {
    percentExample.setType(lstGaugeType.getSelectedIndex());
  }//void lstGaugeType_actionPerformed(ActionEvent

  void lstNeedleStyle_actionPerformed(ActionEvent e) {
    percentExample.setNeedleStyle(lstNeedleStyle.getSelectedIndex());
  }//void lstNeedleStyle_actionPerformed(ActionEvent)

  void lstTickStyle_actionPerformed(ActionEvent e) {
    percentExample.setTickStyle(lstTickStyle.getSelectedIndex());
  }
*/
  public void actionPerformed(ActionEvent evt) {
    Object src = evt.getSource();
    if(src == lstGaugeType) {
      percentExample.setType(lstGaugeType.getSelectedIndex());
    }//if Gauge Type
    else if(src == lstNeedleStyle) {
      percentExample.setType(lstGaugeType.getSelectedIndex());
    }//if Needle Style
    else if(src == lstTickStyle) {
      percentExample.setTickStyle(lstTickStyle.getSelectedIndex());
    }//if Tick Style
  }

}//class JCConfigure