package setimanager;

import com.klg.jclass.swing.gauge.beans.*;
import java.awt.*;
import javax.swing.*;
import java.io.*;

/**
 * Title:        Seti@home Manager
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class StatusViewer extends JFrame implements Runnable {
  GridLayout gridLayout1 = new GridLayout(0, Integer.parseInt(Defaults.COLUMNS_DISPLAY));
  PercentComponent percentComponent[];

  java.util.Properties config = null;
  boolean keepRunning = false;
  Thread statusThread = null;

  private StatusViewer() {}

  public StatusViewer(java.util.Properties config) {
    this.config = config;
    try {
      jbInit();
    } catch(Exception e) {
      e.printStackTrace();
    }//catch
  }//Constructor(java.util.Properties)

  private void jbInit() throws Exception {
    this.setTitle("SETI Status");
    gridLayout1.setColumns(3);
    gridLayout1.setRows(0);
    this.getContentPane().setLayout(gridLayout1);
/*    percentComponent = new PercentComponent[Integer.parseInt(config.getProperty(Constants.SUBDIR_COUNT, Defaults.SUBDIR_COUNT))];
    for(int i = 0 ; i < percentComponent.length; i++) {
      this.getContentPane().add((percentComponent[i] = (PercentComponent)Class.forName(config.getProperty(Constants.PERCENT_CLASS, Defaults.PERCENT_CLASS)).newInstance()).getComponent(config), null);
    }//for
*/    setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);

//    startViewer();
    pack();
  }//private void jbInit()

  void startViewer() {
    if(percentComponent != null) {
      this.getContentPane().removeAll();
      for(int i = 0; i < percentComponent.length; i++) {
        percentComponent[i] = null;
      }//for
      percentComponent = null;
    }//if
    percentComponent = new PercentComponent[Integer.parseInt(config.getProperty(Constants.SUBDIR_COUNT, Defaults.SUBDIR_COUNT))];
    try {
      for(int i = 0 ; i < percentComponent.length; i++) {
        this.getContentPane().add((percentComponent[i] = (PercentComponent)Class.forName(config.getProperty(Constants.PERCENT_CLASS, Defaults.PERCENT_CLASS)).newInstance()).getComponent(config), null);
      }//for
      pack();
      (statusThread = new Thread(this)).start();
    } catch(ClassNotFoundException cnfe) {
      Log.println(5, cnfe);
    } catch(IllegalAccessException iae) {
      Log.println(5, iae);
    } catch(InstantiationException ie) {
      Log.println(5, ie);
    }//catch
  }//void startViewer()

/*  public void show() {
    startViewer();
    super.show();
  }//public void show()
*/
  public void setVisible(boolean visible) {
    if(visible && !isVisible()) {
      if(keepRunning)
        keepRunning = false;
      if(/*!keepRunning && */statusThread != null) {
        try {
          statusThread.join();
        } catch(InterruptedException ie) {
          Log.println(5, ie);
        }//catch
      }//if
//      keepRunning = true;
      startViewer();
    } else if(!visible && isVisible()) {
      keepRunning = false;
    }//else (not visible)
    super.setVisible(visible);
  }//public void setVisible(boolean)

  public void updatePercent(int index, double newPercent) {
    percentComponent[index].setPercent(newPercent);
  }//public void updatePercent(int, double)

  public void updateCount(int index, int newCount) {
    percentComponent[index].setCount(newCount);
  }//public void updateCount(int, int)

  public void updateLabel(int index, String label) {
    percentComponent[index].setLabel(label);
  }//public void updateLabel(int, String)

  public void run() {
    keepRunning = true;
    while(keepRunning) {
      int subdirCount = (percentComponent != null ? percentComponent.length : 0)/*Integer.parseInt(config.getProperty(Constants.SUBDIR_COUNT, Defaults.SUBDIR_COUNT))*/;
      if((config != null) && subdirCount > 0) {
        gridLayout1.setColumns(Integer.parseInt(config.getProperty(Constants.COLUMNS_DISPLAY, Defaults.COLUMNS_DISPLAY)));
        pack();
        for(int i = 0; i < subdirCount; i++) {
          try {
            File setiDir = new File(config.getProperty(Constants.SUBDIR+i));
            BufferedReader inState = new BufferedReader(new FileReader(new File(setiDir, "state.sah"))),
              inUserInfo = new BufferedReader(new FileReader(new File(setiDir, "user_info.sah")));
            String line = inState.readLine();
            while(line != null && !line.trim().startsWith("prog="))
              line = inState.readLine();
            if(line != null) {
              updatePercent(i, Double.parseDouble(line.trim().substring(5)));/* skip "prog=" */
            }//if
            line = inUserInfo.readLine();
            while(line != null && !line.trim().startsWith("nresults="))
              line = inUserInfo.readLine();
            if(line != null) {
              updateCount(i, Integer.parseInt(line.trim().substring(9)));/* skip "nresults=" */
            }//if
            updateLabel(i, setiDir.getName());
          } catch(FileNotFoundException fnfe) {
            updatePercent(i, -1.0);
//              fnfe.printStackTrace();
          } catch(IOException ioe) {
            ioe.printStackTrace();
          }//catch
        }//for
      }//if
      try {
        Thread.sleep(5000);
      } catch(InterruptedException ie) {
        Log.println(5, ie);
      }//catch
    }//while(keepRunning)
    statusThread = null;
  }

}//class StatusViewer
