package setimanager;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import java.net.*;
import java.io.*;
import java.util.Vector;
import java.util.Properties;

/**
 * Title:        Seti@home Manager
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class MainPanel extends JFrame implements Runnable, ActionListener {
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextArea taOutput = new JTextArea();
  JPanel jPanel1 = new JPanel();
//  JButton btnStart = new JButton();
//  JButton btnStop = new JButton();
//  JButton btnConfigDirs = new JButton();
  JButton btnStatusViewer = new JButton();
  JButton btnConfigure = new JButton();

  boolean stopServer = false;
  Vector activeConnections = new Vector();
  DialogSelectDirs dlgSelectDirs = null;
  DialogConfigure dialogConfigure = null;
  StatusViewer frmStatusViewer = null;
  XMLProperties config = new XMLProperties(System.getProperties());
  JMenu mnuProgress = new JMenu();
  JCheckBoxMenuItem mniFile_Progress_ProgressBar = new JCheckBoxMenuItem();
  JCheckBoxMenuItem mniFile_Progress_JClass = new JCheckBoxMenuItem();
  JMenuItem mniFile_Exit = new JMenuItem();

  /**Construct the frame*/
  public MainPanel() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }//public Constructor()

  /**Component initialization*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(Test.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();

    loadSettings();

    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("Java SetiManager");
    statusBar.setText(" ");
    jMenuFile.setText("File");
    jMenuHelp.setText("Help");
    jMenuHelpAbout.setText("About");
    jMenuHelpAbout.addActionListener(this);
/*    btnStart.setText("Start");
    btnStart.addActionListener(this);
    btnStop.setText("Stop");
    btnStop.addActionListener(this);
    btnConfigDirs.setText("Configure Dirs");
    btnConfigDirs.addActionListener(this);
*/    btnStatusViewer.setText("Status");
    btnStatusViewer.addActionListener(this);
    btnConfigure.setText("Configure");
    btnConfigure.addActionListener(this);
    mnuProgress.setText("Progress");
    mniFile_Progress_ProgressBar.setText("ProgressBar");
    mniFile_Progress_ProgressBar.setSelected(true);
    mniFile_Progress_ProgressBar.addActionListener(this);
    mniFile_Progress_JClass.setText("JClass");
    mniFile_Progress_JClass.addActionListener(this);
    mniFile_Exit.setText("Exit");
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuHelp);
    this.setJMenuBar(jMenuBar1);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    contentPane.add(jScrollPane1, BorderLayout.CENTER);
    contentPane.add(jPanel1, BorderLayout.NORTH);
    jPanel1.add(btnConfigure, null);
//    jPanel1.add(btnStart, null);
//    jPanel1.add(btnStop, null);
//    jPanel1.add(btnConfigDirs, null);
    jPanel1.add(btnStatusViewer, null);
    jScrollPane1.getViewport().add(taOutput, null);
    jMenuFile.add(mnuProgress);
    jMenuFile.add(mniFile_Exit);
    mnuProgress.add(mniFile_Progress_ProgressBar);
    mnuProgress.add(mniFile_Progress_JClass);
    if(Boolean.getBoolean("Debug"))
      Log.setLogLevel(1);
  }//private void jbInit()

  void loadSettings() {
    Utils.loadConfig(config);
    mniFile_Progress_JClass.setSelected(config.getProperty(Constants.PERCENT_CLASS, Defaults.PERCENT_CLASS).equals(Constants.PERCENT_CLASS_JCLASS));
    mniFile_Progress_ProgressBar.setSelected(config.getProperty(Constants.PERCENT_CLASS, Defaults.PERCENT_CLASS).equals(Constants.PERCENT_CLASS_PROGRESSBAR));
  }//void loadSettings()

  void saveSettings() {
    Utils.saveConfig(config);
  }//void saveSettings()

  public void run() {
    taOutput.append("Starting server on port "+config.getProperty(Constants.SERVER_PORT, Defaults.SERVER_PORT)+"\n");
    try {
      ServerSocket ssocket = new ServerSocket(Integer.parseInt(config.getProperty(Constants.SERVER_PORT, Defaults.SERVER_PORT)));
      boolean stopThisServer = false;
      stopServer = false;
      while(!stopServer) {
        Socket socket;
        BufferedReader br;
        byte newlines = 0;
        taOutput.append("Accepting connections...\n\n");
        socket = ssocket.accept();
        activeConnections.add(socket);
        br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        taOutput.append("Started serving "+socket.getInetAddress().getHostAddress()+"\n");
        while(!stopThisServer && newlines < 1) {
          String s = br.readLine();
          if(s != null) {
            Log.println(3, s);
            taOutput.append(s+"\n");
            if(s.trim().length() == 0)
              newlines++;
            else
              newlines = 0;
          }//if
          else
            stopThisServer = true;
        }//while this server alive
        taOutput.append("Finished serving "+socket.getInetAddress().getHostAddress()+"\n");
        activeConnections.remove(socket);
        br.close();
        socket.close();
      }//while
      ssocket.close();
    } catch(java.io.IOException ioe) {
      ioe.printStackTrace();
      taOutput.append("\n * * * Errore nella connessione: "+ioe.getMessage()+" * * *\n\n");
    }//catch
  }//public void run()

  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
//      jMenuFileExit_actionPerformed(null);
    }
  }//protected void processWindowEvent(WindowEvent)

  private void stopServing() {
    stopServer = true;
    while(activeConnections.size() > 0) {
      Socket connection = (Socket)activeConnections.elementAt(activeConnections.size() - 1);
      taOutput.append("Closing connection with "+connection.getInetAddress().getHostAddress());
      try {
        connection.close();
      } catch(IOException ioe) {
        ioe.printStackTrace();
        taOutput.append("\n\n * * * Errore nella disconnessione: "+ioe.getMessage()+" * * *\n\n");
      }//catch
      taOutput.append(".\n");
      activeConnections.remove(connection);
    }//while still active connections
  }//private void stopServing()

  DialogSelectDirs getDialogSelectDirs() {
    if(dlgSelectDirs == null) {
      dlgSelectDirs = new DialogSelectDirs(this);
      dlgSelectDirs.setConfiguration(config);
//      dlgSelectDirs.pack();
    }//if
    return dlgSelectDirs;
  }//DialogSelectDirs getDialogSelectDirs()

  DialogConfigure getDialogConfigure() {
    if(dialogConfigure == null) {
      dialogConfigure = new DialogConfigure(this);
      dialogConfigure.setConfiguration(config);
    }//if
    return dialogConfigure;
  }//DialogConfigure getDialogConfigure()

  void toggleStatusViewer() {
    if(frmStatusViewer == null) {
      frmStatusViewer = new StatusViewer(config);
    }//if
    if(frmStatusViewer.isVisible())
      frmStatusViewer.setVisible(false);
    else
      frmStatusViewer.setVisible(true);
  }//void toggleStatusViewer()

/*  /**File | Exit action performed/
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }//public void jMenuFileExit_actionPerformed(ActionEvent)
  /**Help | About action performed/
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
  }//public void jMenuHelpAbout_actionPerformed(ActionEvent)

  void btnStart_actionPerformed(ActionEvent e) {
    (new Thread(this)).start();
  }//void btnStart_actionPerformed(ActionEvent)

  void btnStop_actionPerformed(ActionEvent e) {
    stopServing();
  }//void btnStop_actionPerformed(ActionEvent)

  void btnConfigDirs_actionPerformed(ActionEvent e) {
    getDialogSelectDirs().show();
  }//void btnConfig_actionPerformed(ActionEvent)

  void btnStatusViewer_actionPerformed(ActionEvent e) {
    toggleStatusViewer();
  }//void btnStatusViewer_actionPerformed(ActionEvent)

  void btnConfigure_actionPerformed(ActionEvent e) {
    getDialogConfigure().show();
  }
*/
  public void actionPerformed(ActionEvent evt) {
    Object src = evt.getSource();
    if(src == mniFile_Exit) {
      System.exit(0);
    }//if File->Exit
    else if(src == mniFile_Progress_JClass) {
      config.setProperty(Constants.PERCENT_CLASS, Constants.PERCENT_CLASS_JCLASS);
      mniFile_Progress_JClass.setState(true);
      mniFile_Progress_ProgressBar.setState(false);
      saveSettings();
    }//if File->Progress->JClass
    else if(src == mniFile_Progress_ProgressBar) {
      config.setProperty(Constants.PERCENT_CLASS, Constants.PERCENT_CLASS_PROGRESSBAR);
      mniFile_Progress_ProgressBar.setState(true);
      mniFile_Progress_JClass.setState(false);
      saveSettings();
    }//if File->Progress->JClass
/*    else if(src == btnStart) {
      (new Thread(this)).start();
    }//if "Start"
    else if(src == btnStop) {
      stopServing();
    }//if Stop*/
/*    else if(src == btnConfigDirs) {
      getDialogSelectDirs().show();
    }//if "Config Dirs"*/
    else if(src == btnStatusViewer) {
      toggleStatusViewer();
    }//if "Status Viewer"
    else if(src == btnConfigure) {
      getDialogConfigure().show();
    }//if "Configure"
    else if(src == jMenuHelpAbout) {
    }//if Help->About
  }

}//class setimanager.MainPanel
