package setimanager;

import java.awt.*;
//import com.klg.jclass.swing.gauge.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.io.File;

/**
 * Title:        Seti@home Manager
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class DialogConfigure extends JDialog implements ActionListener {
  JTabbedPane tabPanel = new JTabbedPane();
  JPanel pnlGeneral = new JPanel();

/* Directories panel */
  CFGSelectDirs pnlSelectDirs = null;

  PercentComponent percentComponent = null;

/* OK/cancel buttons */
  JPanel pnlButtons = new JPanel();
  JButton btnOK = new JButton();
  JButton btnCancel = new JButton();

  java.util.Properties configuration = null;
  String gaugeTypes[] = new String[] {"Full circle", "Top half circle", "Bottom half circle",
      "Left half circle", "Right half circle", "Upper right quarter circle", "Lower right quarter circle",
      "Upper left quarter circle", "Lower left quarter circle"},
    needleStyles[] = new String[] {"Tailed Pointer", "Pointer", "Tailed Arrow", "Arrow", "Triangle"},
    tickStyles[] = new String[] {"Diamond", "Triangle", "Reverse Triangle", "Rectangle", "Line", "Circle"};

  public DialogConfigure(java.awt.Frame frame) {
    super(frame, true);
    try {
      jbInit();
    } catch(Exception e) {
      e.printStackTrace();
    }//catch
  }//Constructor(java.awt.Frame)

  private void jbInit() throws Exception {
    DefaultListModel lstModel = new DefaultListModel();
//    this.getContentPane().setLayout(borderLayout2);
    jLabel1.setText("Columns");
    jSlider1.setMinorTickSpacing(1);
    jSlider1.setMajorTickSpacing(5);
    jSlider1.setMinimum(1);
    jSlider1.setValue(2);
    jSlider1.setPaintTicks(true);
    jSlider1.setMaximum(10);
    jSlider1.setSnapToTicks(true);
    this.getContentPane().add(tabPanel, BorderLayout.CENTER);
    tabPanel.add(pnlGeneral, "General");
    pnlGeneral.add(jLabel1, null);
    pnlGeneral.add(jSlider1, null);
    tabPanel.add(pnlSelectDirs = new CFGSelectDirs(), "Directories");
//    tabPanel.add(pnlSelectDirs, "Directories");

/* OK/cancel buttons */
    this.getContentPane().add(pnlButtons, BorderLayout.SOUTH);
    btnOK.setText("OK");
    btnOK.addActionListener(this);
    btnCancel.setText("Cancel");
    btnCancel.addActionListener(this);
    pnlButtons.add(btnOK, null);
    pnlButtons.add(btnCancel, null);

/* Directories panel */
/*    lstDirectories.setModel(lstModel);
    btnRemoveDirectory.setText("Remove");
    btnRemoveDirectory.addActionListener(this);
    btnAddDirectory.setText("Add...");
    btnAddDirectory.addActionListener(this);
    btnScanDirectories.setText("Scan");
    btnScanDirectories.addActionListener(this);
    pnlSelectDirs.setLayout(gridBagLayout1);
    pnlSelectDirs.add(btnRemoveDirectory, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    pnlSelectDirs.add(new JScrollPane(lstDirectories, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    pnlSelectDirs.add(btnAddDirectory, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    pnlSelectDirs.add(btnScanDirectories, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));*/

    pack();
  }//private void jbInit()

  public void show() {
    if(!percentComponent.getClass().getName().equals(configuration.getProperty(Constants.PERCENT_CLASS, Defaults.PERCENT_CLASS))) {
      tabPanel.remove(percentComponent.getComponent(configuration));
      percentComponent = null;

    }//if
    super.show();
  }//public void show()

  public void setConfiguration(java.util.Properties newConfiguration) {
    int subdirCount = Utils.getSubdirCount(newConfiguration);
    configuration = newConfiguration;
    pnlSelectDirs.clearDirs();
/*    if(lstDirectories.getModel().getSize() > 0) {
      lstDirectories.removeAll();
    }//if*/
    if(subdirCount > 0) {
      for(int i = 0; i < subdirCount; i++) {
        pnlSelectDirs.addDir(Utils.getSubdir(configuration, i));
      }//for
    }//if
    try {
      percentComponent = (PercentComponent)Class.forName(configuration.getProperty(Constants.PERCENT_CLASS, Defaults.PERCENT_CLASS)).newInstance();
      tabPanel.add(percentComponent.getConfigComponent(configuration), "Indicator Options");
    } catch(ClassNotFoundException cnfe) {
      cnfe.printStackTrace();
    } catch(IllegalAccessException iae) {
      iae.printStackTrace();
    } catch(InstantiationException ie) {
      ie.printStackTrace();
    }//catch
  }//public void setConfiguration(java.util.Properties)

  public java.util.Properties getConfiguration() {
    if(configuration == null)
      configuration = new java.util.Properties();
    return configuration;
  }//public java.util.Properties getConfiguration()

  boolean isSetiDir(File dir) {
    if((new File(dir, "state.sah")).exists()) {
      Log.println(3, "Found state.sah in "+dir);
      return true;
    }//if
    Log.println(3, "state.sah not found in "+dir);
    return false;
  }//boolean isSetiDir(File)

  File[] findSetiSubdirs(File startDir) {
    File result[] = null, subdirs[] = null;
    java.util.Vector resultV = new java.util.Vector();
    Log.println(2, "Scanning "+startDir);
    if(isSetiDir(startDir)) {
      Log.println(3, "Adding '"+startDir+"'");
      resultV.addElement(startDir);
    }//if startDir is SETI dir
    subdirs = startDir.listFiles(DirFilter.dirFilter);
    if(subdirs != null) {
      for(int i = 0; i < subdirs.length; i++) {
        File file[] = findSetiSubdirs(subdirs[i]);
        if(file != null) {
          for(int j = 0; j < file.length; j++) {
//            Log.println(3, new Throwable("Adding "+file[j]));
            resultV.addElement(file[j]);
          }//for j
        }//if: no SETI subdirs
      }//for i
    }//if: startDir has subfiles/subdirs
    if(resultV.size() > 0) {
      result = new File[resultV.size()];
      resultV.toArray(result);
    }//if
    else
      result = null;
    return result;
  }//File[] findSetiSubdirs(File)

  public void actionPerformed(ActionEvent evt) {
    Object src = evt.getSource();
    if(src == btnOK) {
      percentComponent.confirmConfig();
      Utils.setSubdirs(configuration, pnlSelectDirs.lstDirectories.getModel());
      Utils.saveConfig(configuration);
      setVisible(false);
    }//if OK
    else if(src == btnCancel) {
      percentComponent.cancelConfig();
      setVisible(false);
    }//if Cancel
  }
  JLabel jLabel1 = new JLabel();
  JSlider jSlider1 = new JSlider();

}//class DialogConfigure