package setimanager.percent;

import javax.swing.*;
import java.awt.*;

/**
 * Title:        Seti@home Manager
 * Description:  A PercentComponent which uses ProgressBar (from Swing)
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class ProgressBar extends JComponent implements setimanager.PercentComponent {

  JProgressBar progressComponent = new JProgressBar();
  java.util.Properties configuration = null;
  javax.swing.JLabel lblFooter = new javax.swing.JLabel();
  JLabel configureComponent = null, lblWUCount = new JLabel("0"), lblDirectory = new JLabel(".");

  public ProgressBar() {
    if(configuration != null) {
      progressComponent.setString("0%");
    }//if
    try {
      jbInit();
    }  catch(Exception e) {
      e.printStackTrace();
    }//catch
  }//Constructor()

  public void setPercent(double newPercent) {
    if(newPercent >= 0.0) {
      progressComponent.setValue(Math.round((float)newPercent * 100));
      progressComponent.setString((100.0*newPercent+"").substring(0, 5)+"%");
    } else {
      setBackground(java.awt.Color.red);
    }//else (percent <0)
  }//public void setPercent(double)

  public void setCount(int newCount) {
    lblWUCount.setText(""+newCount);
  }//public void setCount(int)

  public void setLabel(String label) {
    lblDirectory.setText(label);
  }//public void setLabel(String)

  public javax.swing.JComponent getComponent(java.util.Properties configuration) {
    this.configuration = configuration;
    return this;
  }//public javax.swing.JComponent getComponent()

  public javax.swing.JComponent getConfigComponent(java.util.Properties configuration) {
    this.configuration = configuration;
    if(configureComponent == null) {
      configureComponent = new JLabel("Nothing to configure");
    }//if null
    return configureComponent;
  }//public javax.swing.JComponent getConfigComponent(java.util.Properties)

  public void confirmConfig() {
  }//public void confirmConfig()

  public void cancelConfig() {
  }//public void cancelConfig()

  private void jbInit() throws Exception {
    progressComponent.setStringPainted(true);
    this.setLayout(gridLayout1);
    gridLayout1.setColumns(3);
    gridLayout1.setHgap(3);
    lblDirectory.setHorizontalAlignment(SwingConstants.TRAILING);
    this.add(lblDirectory, null);
    this.add(progressComponent, null);
    add(lblWUCount, null);
  }
  GridLayout gridLayout1 = new GridLayout();

}//class ProgressBar
