package setimanager.percent;

import com.klg.jclass.swing.gauge.beans.*;
import javax.swing.*;
import java.awt.*;

/**
 * Title:        Seti@home Manager
 * Description:  A PercentComponent which uses JCCircularGaugeBean (from JClass)
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class JC extends JComponent implements setimanager.PercentComponent {

  java.util.Properties configuration = null;
  JCCircularGaugeBean percentComponent = new JCCircularGaugeBean();
  javax.swing.JLabel lblFooter = new javax.swing.JLabel("0%");
  JCConfigure configureComponent = null;
  JLabel lblWUCount = new JLabel();
  JLabel lblDirectory = new JLabel();
  GridLayout gridLayout1 = new GridLayout();

  public JC() {
/*    if(configuration != null) {
      setType(Integer.parseInt(configuration.getProperty(JCConstants.GAUGE_TYPE, JCDefaults.GAUGE_TYPE)));
      setTickStyle(Integer.parseInt(configuration.getProperty(JCConstants.TICK_STYLE, JCDefaults.TICK_STYLE)));
      setNeedleStyle(Integer.parseInt(configuration.getProperty(JCConstants.NEEDLE_STYLE, JCDefaults.NEEDLE_STYLE)));
      lblFooter.setText("0%");
    }//if
*/
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }  }//Constructor()

  public void setPercent(double newPercent) {
    if(newPercent >= 0.0) {
      percentComponent.setNeedleValue(newPercent * 100.0);
      lblFooter.setText((100.0*newPercent+"").substring(0, 5)+"%");
    } else {
    }//else (percent <0)
  }//public void setPercent(double)

  public void setCount(int newCount) {
    lblWUCount.setText(""+newCount);
  }//public void setCount(int)

  public void setLabel(String label) {
    lblDirectory.setText(label);
  }//public void setLabel(String)

  void setConfiguration(java.util.Properties configuration) {
    if(configuration != null) {
      percentComponent.setType(Integer.parseInt(configuration.getProperty(JCConstants.GAUGE_TYPE, JCDefaults.GAUGE_TYPE)));
      percentComponent.setTickStyle(Integer.parseInt(configuration.getProperty(JCConstants.TICK_STYLE, JCDefaults.TICK_STYLE)));
      percentComponent.setNeedleStyle(Integer.parseInt(configuration.getProperty(JCConstants.NEEDLE_STYLE, JCDefaults.NEEDLE_STYLE)));
    }//if
    this.configuration = configuration;
  }//void setConfiguration(java.util.Properties)

  public javax.swing.JComponent getComponent(java.util.Properties configuration) {
    setConfiguration(configuration);
    return this;
  }//public javax.swing.JComponent getComponent()

  public javax.swing.JComponent getConfigComponent(java.util.Properties configuration) {
    if(configureComponent == null) {
      configureComponent = new JCConfigure();
      configureComponent.setConfiguration(configuration);
      setConfiguration(configuration);
    }//if null
    return configureComponent;
  }//public javax.swing.JComponent getConfigComponent(java.util.Properties)

  public void confirmConfig() {
    configuration.setProperty(JCConstants.GAUGE_TYPE, ""+configureComponent.lstGaugeType.getSelectedIndex());
    configuration.setProperty(JCConstants.NEEDLE_STYLE, ""+configureComponent.lstNeedleStyle.getSelectedIndex());
    configuration.setProperty(JCConstants.TICK_STYLE, ""+configureComponent.lstTickStyle.getSelectedIndex());
  }//public void confirmConfig()

  public void cancelConfig() {
    configureComponent.lstGaugeType.setSelectedIndex(Integer.parseInt(configuration.getProperty(JCConstants.GAUGE_TYPE, JCDefaults.GAUGE_TYPE)));
    configureComponent.lstNeedleStyle.setSelectedIndex(Integer.parseInt(configuration.getProperty(JCConstants.NEEDLE_STYLE, JCDefaults.NEEDLE_STYLE)));
    configureComponent.lstTickStyle.setSelectedIndex(Integer.parseInt(configuration.getProperty(JCConstants.TICK_STYLE, JCDefaults.TICK_STYLE)));
  }//public void cancelConfig()

  private void jbInit() throws Exception {
    this.setLayout(gridLayout1);
    lblWUCount.setText("0");
    lblDirectory.setText(".");
    gridLayout1.setColumns(3);
    gridLayout1.setHgap(3);
    this.add(lblWUCount, null);
    this.add(percentComponent, null);
    this.add(lblDirectory, null);
  }

}//class JC
