package setimanager;

import java.io.*;
import java.util.zip.GZIPOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.Properties;

/**
 * Title:        Seti@home Manager
 * Description:  A set of utility methods, mainly forconfiguration handling
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class Utils {

//  static Properties configuration = null;

  private Utils() {}//private Constructor

/**
 * Get the directory count in <CODE>configuration</CODE>.
 */
  public static int getSubdirCount(Properties configuration) {
    return Integer.parseInt(configuration.getProperty(Constants.SUBDIR_COUNT, Defaults.SUBDIR_COUNT));
  }//public static int getSubdirCount(Properties)

/**
 * Get the directory at index <CODE>index</CODE> in <CODE>configuration</CODE>
 */
  public static File getSubdir(Properties configuration, int index) {
    return new File(configuration.getProperty(Constants.SUBDIR+index));
  }//public static File getSubdir(Properties, int)

/**
 * Fill the ListModel with the directories from the configuration
 */
  public static void getSubdirs(Properties configuration, javax.swing.DefaultListModel subdirs) {
    int subdirCount = getSubdirCount(configuration);
    subdirs.clear();
    for(int i = 0; i < subdirCount; i++) {
      subdirs.addElement(getSubdir(configuration, i));
    }//for
  }//public static void getSubdirs(Properties, int, javax.swing.ListModel)

/**
 * Set the directory count in <CODE>configuration</CODE> to <CODE>count</CODE>.
 * Note: doesn't remove any directory name from <CODE>configuration</CODE>
 */
  public static void setSubdirCount(Properties configuration, int count) {
    configuration.setProperty(Constants.SUBDIR_COUNT, ""+count);
  }//public static void setSubdirCount(Properties, int)

/**
 * Set the directory at index <CODE>index</CODE> in <CODE>configuration</CODE> to <CODE>subdir</CODE>
 */
  public static void setSubdir(Properties configuration, int index, File subdir) {
    configuration.setProperty(Constants.SUBDIR+index, subdir.toString());
  }//public static void setSubdir(Properties, int, File)

/**
 * Fill the configuration with the directories from the ListModel
 */
  public static void setSubdirs(Properties configuration, javax.swing.ListModel subdirs) {
    int subdirCount = getSubdirCount(configuration);
    if(subdirCount > 0) {
      for(int i = 0; i < subdirCount; i++) {
        configuration.remove(Constants.SUBDIR+i);
      }//for
    }//if
    setSubdirCount(configuration, subdirs.getSize());
    subdirCount = subdirs.getSize();
    for(int i = 0; i < subdirCount; i++) {
      setSubdir(configuration, i, (File)subdirs.getElementAt(i));
    }//for
  }//public static void setSubdirs(Properties, int, javax.swing.ListModel)

/**
 * Save the configuration to the file specified in the Properties (or the default one)
 */
  public static void saveConfig(Properties config) {
    saveConfig(config, new File(config.getProperty(Constants.CONFIG_FILE, Defaults.CONFIG_FILE)));
  }//saveConfig(Properties)

/**
 * Save the configuration to the file specified
 */
  public static void saveConfig(Properties config, File file) {
    try {
      GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(file));
      config.store(gzos, "SetiManager config");
      gzos.close();
    } catch(FileNotFoundException fnfe) {
      fnfe.printStackTrace();
    } catch(IOException ioe) {
      ioe.printStackTrace();
    }//catch
  }//public static void saveConfig(java.util.Properties, java.io.File)

/**
 * Load the configuration from the file specified in the Properties (or the default one)
 */
  public static void loadConfig(Properties config) {
    loadConfig(config, new File(config.getProperty(Constants.CONFIG_FILE, Defaults.CONFIG_FILE)));
  }//public static void loadConfig(Properties)

/**
 * Load the configuration from the file specified
 */
  public static void loadConfig(Properties config, File file) {
    try {
      GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(file));
      config.load(gzis);
    } catch(FileNotFoundException fnfe) {
//      ioe.printStackTrace();
      Log.println(5, "Config file ("+file+") not found: creating one ("+fnfe.getMessage()+")");
      saveConfig(config, file);
    } catch(IOException ioe) {
      ioe.printStackTrace();
    }//catch
  }//public static void loadConfig(java.util.Properties, java.io.File)

}//class Utils