package setimanager;

import java.io.*;

/**
 * Log.java
 *
 * Used to print a log on file from any class: is contains only static methods.
 * A program should invoke {@Link Log.println(int, String) Log.println(priority, "Message");}
 * to write a message to the log file, or {@Link Log.println(int, Throwable)
 * Log.println(priority, Exception);} to log an exception.
 *
 * Created: Mon Jun  7 10:34:25 1999
 *
 * @author Mario Bozzetti & Nicola Canepa
 * @version 1.1
 */
public final class Log  {

  private static String logFile = "Program.log";

  /**
   * The actual level of logging: a message is written to the log file only if its
   * priority is higher than logLevel.
   */
  private static byte logLevel = 5;
  static {
    if(Boolean.getBoolean("Debug")) {
      System.out.println("Debug attivo: "+(new File(logFile)).getAbsolutePath());
      logLevel = 0;
    }//if
  }//static
  private static java.text.DateFormat dformat = java.text.DateFormat.getDateTimeInstance(java.text.DateFormat.SHORT, java.text.DateFormat.SHORT, java.util.Locale.ITALY);
  /* Locale is there to have DD/MM/YYYY and HH:MM in 24h format */

  /**
   * Select the file to use for logging.
   * @param fileName the name of the file to use.
   */
  public static void setLogFile(String fileName) {
    logFile = fileName;
  }//public static void setLogFile(String)

  /**
   * Delete the file used for logging.
   * @return <CODE>true</CODE> if the file was actually removed; <CODE>false</CODE> otherwise.
   */
  public static boolean removeLogFile() {
    File f = new File(logFile);
    if(f.isFile())
      return f.delete();
    return false;
  }//public static boolean setLogFile(String)

/**
 * Sets the log level:
 *  1 is for debugging purposes only (logs everything)
 *  9 logs only the most important errors
 * 10 logs nothing
 * @param newLevel the requested LogLevel from now on.
 */
  public static void setLogLevel(int newLevel) {
    logLevel = (byte)newLevel;
  }//public static void setLogLevel(int)

/**
 * Returns the current log level:
 * @return the current log level.
 */
  public static int getLogLevel() {
    return logLevel;
  }//public static void setLogLevel(int)

/**
 * Appends a line to the log file, if the priority is higher or equals the current logLevel
 * @param priority the priority of the message.
 * @param s the message to log.
 */
  public static void println(int priority, String s) {
    PrintWriter out = null;
    if(priority >= 10)
      priority = 9;
    if(priority >= logLevel) {
      synchronized(logFile) {
        try {
          out = new PrintWriter(new BufferedWriter(new FileWriter(logFile, true)));
        } catch(IOException ioe) {
          ioe.printStackTrace();
        }//catch
        if(out != null) {
          String dateTime = dformat.format(java.util.Calendar.getInstance().getTime())+" ";
          java.util.StringTokenizer st = new java.util.StringTokenizer(s, "\n\f\r");
          while(st.hasMoreTokens())
            out.println(dateTime+st.nextToken());
          out.close();
        }//if(out != null)
        if(priority <= 1)
          System.out.println(s);
      }//if(priority >= logLevel)
    }//synchronized(logFile)
  }//public static void println(int, String)

/**
 * Appends the stack trace to the log file, if the level is higher or equals the current log level
 * @param priority the priority of the message.
 * @param t the Exception (or Error) to log.
 * @see java.lang.Throwable
 */
  public static void println(int level, Throwable t) {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    String s;
    if(logLevel < 4)
      t.printStackTrace(pw);
    else
      pw.println(t.getLocalizedMessage());
    println(level, sw.toString());
  }//public static println(int, Throwable)

}//public class Log
