package setimanager;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * Title:        Seti@home Manager
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Nicola Canepa
 * @version 1.0
 */

public class CFGSelectDirs extends JComponent implements ActionListener {
  JPanel pnlSelectDirs = new JPanel();
  JList lstDirectories = new JList();
  JButton btnRemoveDirectory = new JButton();
  JButton btnAddDirectory = new JButton();
  JButton btnScanDirectories = new JButton();
  BorderLayout borderLayout1 = new BorderLayout();
  GridBagLayout gridBagLayout1 = new GridBagLayout();

  JFileChooser dlgCorrentDirectory;

  public CFGSelectDirs(/*java.awt.Frame frame*/) {
    try {
      jbInit();
    } catch(Exception e) {
      e.printStackTrace();
    }//catch
  }//Constructor(java.awt.Frame)

  private void jbInit() throws Exception {
    DefaultListModel lstModel = new DefaultListModel();
    setLayout(borderLayout1);
    lstDirectories.setModel(lstModel);
    btnRemoveDirectory.setText("Remove");
    btnRemoveDirectory.addActionListener(this);
    btnAddDirectory.setText("Add...");
    btnAddDirectory.addActionListener(this);
    btnScanDirectories.setText("Scan");
    btnScanDirectories.addActionListener(this);
    pnlSelectDirs.setLayout(gridBagLayout1);
    this.add(pnlSelectDirs, BorderLayout.CENTER);
    pnlSelectDirs.add(btnRemoveDirectory, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    pnlSelectDirs.add(new JScrollPane(lstDirectories, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    pnlSelectDirs.add(btnAddDirectory, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    pnlSelectDirs.add(btnScanDirectories, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));

  }//jbInit()

  public void clearDirs() {
    if(lstDirectories.getModel().getSize() > 0) {
      lstDirectories.removeAll();
    }//if
  }//public void clearDirs()

  boolean isSetiDir(File dir) {
    if((new File(dir, "state.sah")).exists()) {
      Log.println(3, "Found state.sah in "+dir);
      return true;
    }//if
    Log.println(3, "state.sah not found in "+dir);
    return false;
  }//boolean isSetiDir(File)

  File[] findSetiSubdirs(File startDir) {
    File result[] = null, subdirs[] = null;
    java.util.Vector resultV = new java.util.Vector();
    Log.println(2, "Scanning "+startDir);
    if(isSetiDir(startDir)) {
      Log.println(3, "Adding '"+startDir+"'");
      resultV.addElement(startDir);
    }//if startDir is SETI dir
    subdirs = startDir.listFiles(DirFilter.dirFilter);
    if(subdirs != null) {
      for(int i = 0; i < subdirs.length; i++) {
        File file[] = findSetiSubdirs(subdirs[i]);
        if(file != null) {
          for(int j = 0; j < file.length; j++) {
//            Log.println(3, new Throwable("Adding "+file[j]));
            resultV.addElement(file[j]);
          }//for j
        }//if: no SETI subdirs
      }//for i
    }//if: startDir has subfiles/subdirs
    if(resultV.size() > 0) {
      result = new File[resultV.size()];
      resultV.toArray(result);
    }//if
    else
      result = null;
    return result;
  }//File[] findSetiSubdirs(File)

  void scanDirs() {
    if(getDirectoryDialog().getSelectedFile() != null) {
      File setiDirs[] = (getDirectoryDialog().getSelectedFile().isDirectory()?findSetiSubdirs(getDirectoryDialog().getSelectedFile()):null);
      ((DefaultListModel)lstDirectories.getModel()).clear();
      if(setiDirs != null) {
        for(int i = 0; i < setiDirs.length; i++)
          addDir(setiDirs[i]);
      }//if
    }//if not null
  }//void scanDirs()

/**
 * Add a directory to the Component on screen
 */
  public void addDir(File dir) {
    Log.println(3, "Adding '"+dir+"'");
    ((DefaultListModel)lstDirectories.getModel()).addElement(dir);
  }//public void addDir(File)

  public void removeDir(File dir) {
    Log.println(3, "Removing '"+dir+"'");
    ((DefaultListModel)lstDirectories.getModel()).removeElement(dir);
  }//public void removeDir(File)

  public void removeDir(int index) {
    Log.println(3, "Removing "+index);
    ((DefaultListModel)lstDirectories.getModel()).removeElementAt(index);
  }//public void removeDir(int)

  public void removeSelectedDirs() {
    if(lstDirectories.getSelectedIndex() >= 0) {
      int indexes[] = lstDirectories.getSelectedIndices();
      for (int i = 0; i < indexes.length; i++)
        removeDir(i);
    }//if
  }//public void removeSelectedDirs()

  JFileChooser getDirectoryDialog() {
    if(dlgCorrentDirectory == null) {
      dlgCorrentDirectory = new JFileChooser("");
      dlgCorrentDirectory.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    }//if no dialog
    return dlgCorrentDirectory;
  }//JFileChooser getDirectoryDialog()

  public void actionPerformed(ActionEvent evt) {
    Object src = evt.getSource();
    if(src == btnRemoveDirectory) {
      if(lstDirectories.getSelectedIndex() >= 0)
        removeDir(lstDirectories.getSelectedIndex());
    }//if Remove Dir
    else if(src == btnAddDirectory) {
      if(getDirectoryDialog().showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
        if(getDirectoryDialog().getSelectedFile() != null) {
          if(isSetiDir(getDirectoryDialog().getSelectedFile())) {
            addDir(getDirectoryDialog().getSelectedFile());
          } else {
            JOptionPane.showMessageDialog(this, "Not a SETI directory!");
          }//else (not a SETI dir)
        }//if selection not null
      }//if user selected "Open"
    }//if Add Dir
    else if(src == btnScanDirectories) {
      if(getDirectoryDialog().showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
        if(getDirectoryDialog().getSelectedFile() != null) {
          scanDirs();
        }//if selection not null
      }//if user selected "Open"
    }//if Scan Directories
  }

}//class CFGSelectDirs
