/*
 * Decompiled with CFR 0.152.
 */
package setimanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import setimanager.Log;

public class Utils {
    private Utils() {
    }

    public static int getSubdirCount(Properties properties) {
        return Integer.parseInt(properties.getProperty("setimanager.SubdirCount", "0"));
    }

    public static File getSubdir(Properties properties, int n) {
        return new File(properties.getProperty("setimanager.Dir" + n));
    }

    public static void getSubdirs(Properties properties, DefaultListModel defaultListModel) {
        int n = Utils.getSubdirCount(properties);
        defaultListModel.clear();
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.addElement(Utils.getSubdir(properties, n2));
            ++n2;
        }
    }

    public static void setSubdirCount(Properties properties, int n) {
        properties.setProperty("setimanager.SubdirCount", "" + n);
    }

    public static void setSubdir(Properties properties, int n, File file) {
        properties.setProperty("setimanager.Dir" + n, file.toString());
    }

    public static void setSubdirs(Properties properties, ListModel listModel) {
        int n;
        int n2 = Utils.getSubdirCount(properties);
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                ((Hashtable)properties).remove("setimanager.Dir" + n);
                ++n;
            }
        }
        Utils.setSubdirCount(properties, listModel.getSize());
        n2 = listModel.getSize();
        n = 0;
        while (n < n2) {
            Utils.setSubdir(properties, n, (File)listModel.getElementAt(n));
            ++n;
        }
    }

    public static void saveConfig(Properties properties) {
        Utils.saveConfig(properties, new File(properties.getProperty("setimanager.ConfigFile", "SetiManager.cfg")));
    }

    public static void saveConfig(Properties properties, File file) {
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            properties.store(gZIPOutputStream, "SetiManager config");
            gZIPOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void loadConfig(Properties properties) {
        Utils.loadConfig(properties, new File(properties.getProperty("setimanager.ConfigFile", "SetiManager.cfg")));
    }

    public static void loadConfig(Properties properties, File file) {
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
            properties.load(gZIPInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.println(5, "Config file (" + file + ") not found: creating one (" + fileNotFoundException.getMessage() + ")");
            Utils.saveConfig(properties, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

