/*
 * Decompiled with CFR 0.152.
 */
package setimanager;

import java.awt.Component;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;
import setimanager.Log;
import setimanager.PercentComponent;

public class StatusViewer
extends JFrame
implements Runnable {
    GridLayout gridLayout1 = new GridLayout(0, Integer.parseInt("2"));
    PercentComponent[] percentComponent;
    Properties config = null;
    boolean keepRunning = false;
    Thread statusThread = null;

    private StatusViewer() {
    }

    public StatusViewer(Properties properties) {
        this.config = properties;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("SETI Status");
        this.gridLayout1.setColumns(3);
        this.gridLayout1.setRows(0);
        this.getContentPane().setLayout(this.gridLayout1);
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    void startViewer() {
        int n;
        if (this.percentComponent != null) {
            this.getContentPane().removeAll();
            n = 0;
            while (n < this.percentComponent.length) {
                this.percentComponent[n] = null;
                ++n;
            }
            this.percentComponent = null;
        }
        this.percentComponent = new PercentComponent[Integer.parseInt(this.config.getProperty("setimanager.SubdirCount", "0"))];
        try {
            n = 0;
            while (n < this.percentComponent.length) {
                this.percentComponent[n] = (PercentComponent)Class.forName(this.config.getProperty("setimanager.PercentIndicator", "setimanager.percent.ProgressBar")).newInstance();
                this.getContentPane().add((Component)this.percentComponent[n].getComponent(this.config), null);
                ++n;
            }
            this.pack();
            this.statusThread = new Thread(this);
            this.statusThread.start();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.println(5, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.println(5, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Log.println(5, instantiationException);
        }
    }

    public void setVisible(boolean bl) {
        if (bl && !this.isVisible()) {
            if (this.keepRunning) {
                this.keepRunning = false;
            }
            if (this.statusThread != null) {
                try {
                    this.statusThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.println(5, interruptedException);
                }
            }
            this.startViewer();
        } else if (!bl && this.isVisible()) {
            this.keepRunning = false;
        }
        super.setVisible(bl);
    }

    public void updatePercent(int n, double d) {
        this.percentComponent[n].setPercent(d);
    }

    public void updateCount(int n, int n2) {
        this.percentComponent[n].setCount(n2);
    }

    public void updateLabel(int n, String string) {
        this.percentComponent[n].setLabel(string);
    }

    public void run() {
        this.keepRunning = true;
        while (this.keepRunning) {
            int n;
            int n2 = n = this.percentComponent != null ? this.percentComponent.length : 0;
            if (this.config != null && n > 0) {
                this.gridLayout1.setColumns(Integer.parseInt(this.config.getProperty("setimanager.Columns", "2")));
                this.pack();
                int n3 = 0;
                while (n3 < n) {
                    try {
                        File file = new File(this.config.getProperty("setimanager.Dir" + n3));
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(file, "state.sah")));
                        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(new File(file, "user_info.sah")));
                        String string = bufferedReader.readLine();
                        while (string != null && !string.trim().startsWith("prog=")) {
                            string = bufferedReader.readLine();
                        }
                        if (string != null) {
                            this.updatePercent(n3, Double.parseDouble(string.trim().substring(5)));
                        }
                        string = bufferedReader2.readLine();
                        while (string != null && !string.trim().startsWith("nresults=")) {
                            string = bufferedReader2.readLine();
                        }
                        if (string != null) {
                            this.updateCount(n3, Integer.parseInt(string.trim().substring(9)));
                        }
                        this.updateLabel(n3, file.getName());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.updatePercent(n3, -1.0);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    ++n3;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                Log.println(5, interruptedException);
            }
        }
        this.statusThread = null;
    }
}

