/*
 * Decompiled with CFR 0.152.
 */
package setimanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import setimanager.DialogConfigure;
import setimanager.DialogSelectDirs;
import setimanager.Log;
import setimanager.StatusViewer;
import setimanager.Utils;
import setimanager.XMLProperties;

public class MainPanel
extends JFrame
implements Runnable,
ActionListener {
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea taOutput = new JTextArea();
    JPanel jPanel1 = new JPanel();
    JButton btnStatusViewer = new JButton();
    JButton btnConfigure = new JButton();
    boolean stopServer = false;
    Vector activeConnections = new Vector();
    DialogSelectDirs dlgSelectDirs = null;
    DialogConfigure dialogConfigure = null;
    StatusViewer frmStatusViewer = null;
    XMLProperties config = new XMLProperties(System.getProperties());
    JMenu mnuProgress = new JMenu();
    JCheckBoxMenuItem mniFile_Progress_ProgressBar = new JCheckBoxMenuItem();
    JCheckBoxMenuItem mniFile_Progress_JClass = new JCheckBoxMenuItem();
    JMenuItem mniFile_Exit = new JMenuItem();

    public MainPanel() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.loadSettings();
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(400, 300));
        this.setTitle("Java SetiManager");
        this.statusBar.setText(" ");
        this.jMenuFile.setText("File");
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(this);
        this.btnStatusViewer.setText("Status");
        this.btnStatusViewer.addActionListener(this);
        this.btnConfigure.setText("Configure");
        this.btnConfigure.addActionListener(this);
        this.mnuProgress.setText("Progress");
        this.mniFile_Progress_ProgressBar.setText("ProgressBar");
        this.mniFile_Progress_ProgressBar.setSelected(true);
        this.mniFile_Progress_ProgressBar.addActionListener(this);
        this.mniFile_Progress_JClass.setText("JClass");
        this.mniFile_Progress_JClass.addActionListener(this);
        this.mniFile_Exit.setText("Exit");
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jScrollPane1, "Center");
        this.contentPane.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.btnConfigure, null);
        this.jPanel1.add((Component)this.btnStatusViewer, null);
        this.jScrollPane1.getViewport().add((Component)this.taOutput, null);
        this.jMenuFile.add(this.mnuProgress);
        this.jMenuFile.add(this.mniFile_Exit);
        this.mnuProgress.add(this.mniFile_Progress_ProgressBar);
        this.mnuProgress.add(this.mniFile_Progress_JClass);
        if (Boolean.getBoolean("Debug")) {
            Log.setLogLevel(1);
        }
    }

    void loadSettings() {
        Utils.loadConfig(this.config);
        this.mniFile_Progress_JClass.setSelected(this.config.getProperty("setimanager.PercentIndicator", "setimanager.percent.ProgressBar").equals("setimanager.percent.JC"));
        this.mniFile_Progress_ProgressBar.setSelected(this.config.getProperty("setimanager.PercentIndicator", "setimanager.percent.ProgressBar").equals("setimanager.percent.ProgressBar"));
    }

    void saveSettings() {
        Utils.saveConfig(this.config);
    }

    public void run() {
        this.taOutput.append("Starting server on port " + this.config.getProperty("setimanager.Proxy.Port", "2903") + "\n");
        try {
            ServerSocket serverSocket = new ServerSocket(Integer.parseInt(this.config.getProperty("setimanager.Proxy.Port", "2903")));
            boolean bl = false;
            this.stopServer = false;
            while (!this.stopServer) {
                int n = 0;
                this.taOutput.append("Accepting connections...\n\n");
                Socket socket = serverSocket.accept();
                this.activeConnections.add(socket);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.taOutput.append("Started serving " + socket.getInetAddress().getHostAddress() + "\n");
                while (!bl && n < 1) {
                    String string = bufferedReader.readLine();
                    if (string != null) {
                        Log.println(3, string);
                        this.taOutput.append(string + "\n");
                        if (string.trim().length() == 0) {
                            n = (byte)(n + 1);
                            continue;
                        }
                        n = 0;
                        continue;
                    }
                    bl = true;
                }
                this.taOutput.append("Finished serving " + socket.getInetAddress().getHostAddress() + "\n");
                this.activeConnections.remove(socket);
                bufferedReader.close();
                socket.close();
            }
            serverSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.taOutput.append("\n * * * Errore nella connessione: " + iOException.getMessage() + " * * *\n\n");
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            System.exit(0);
        }
    }

    private void stopServing() {
        this.stopServer = true;
        while (this.activeConnections.size() > 0) {
            Socket socket = (Socket)this.activeConnections.elementAt(this.activeConnections.size() - 1);
            this.taOutput.append("Closing connection with " + socket.getInetAddress().getHostAddress());
            try {
                socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.taOutput.append("\n\n * * * Errore nella disconnessione: " + iOException.getMessage() + " * * *\n\n");
            }
            this.taOutput.append(".\n");
            this.activeConnections.remove(socket);
        }
    }

    DialogSelectDirs getDialogSelectDirs() {
        if (this.dlgSelectDirs == null) {
            this.dlgSelectDirs = new DialogSelectDirs(this);
            this.dlgSelectDirs.setConfiguration(this.config);
        }
        return this.dlgSelectDirs;
    }

    DialogConfigure getDialogConfigure() {
        if (this.dialogConfigure == null) {
            this.dialogConfigure = new DialogConfigure(this);
            this.dialogConfigure.setConfiguration(this.config);
        }
        return this.dialogConfigure;
    }

    void toggleStatusViewer() {
        if (this.frmStatusViewer == null) {
            this.frmStatusViewer = new StatusViewer(this.config);
        }
        if (this.frmStatusViewer.isVisible()) {
            this.frmStatusViewer.setVisible(false);
        } else {
            this.frmStatusViewer.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mniFile_Exit) {
            System.exit(0);
        } else if (object == this.mniFile_Progress_JClass) {
            this.config.setProperty("setimanager.PercentIndicator", "setimanager.percent.JC");
            this.mniFile_Progress_JClass.setState(true);
            this.mniFile_Progress_ProgressBar.setState(false);
            this.saveSettings();
        } else if (object == this.mniFile_Progress_ProgressBar) {
            this.config.setProperty("setimanager.PercentIndicator", "setimanager.percent.ProgressBar");
            this.mniFile_Progress_ProgressBar.setState(true);
            this.mniFile_Progress_JClass.setState(false);
            this.saveSettings();
        } else if (object == this.btnStatusViewer) {
            this.toggleStatusViewer();
        } else if (object == this.btnConfigure) {
            this.getDialogConfigure().show();
        } else if (object == this.jMenuHelpAbout) {
            // empty if block
        }
    }
}

