/*
 * Decompiled with CFR 0.152.
 */
package setimanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;

public final class Log {
    private static String logFile = "Program.log";
    private static byte logLevel = (byte)5;
    private static DateFormat dformat;

    public static void setLogFile(String string) {
        logFile = string;
    }

    public static boolean removeLogFile() {
        File file = new File(logFile);
        if (file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static void setLogLevel(int n) {
        logLevel = (byte)n;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void println(int n, String string) {
        PrintWriter printWriter = null;
        if (n >= 10) {
            n = 9;
        }
        if (n >= logLevel) {
            String string2 = logFile;
            synchronized (string2) {
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(logFile, true)));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (printWriter != null) {
                    String string3 = dformat.format(Calendar.getInstance().getTime()) + " ";
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\f\r");
                    while (stringTokenizer.hasMoreTokens()) {
                        printWriter.println(string3 + stringTokenizer.nextToken());
                    }
                    printWriter.close();
                }
                if (n <= 1) {
                    System.out.println(string);
                }
            }
        }
    }

    public static void println(int n, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (logLevel < 4) {
            throwable.printStackTrace(printWriter);
        } else {
            printWriter.println(throwable.getLocalizedMessage());
        }
        Log.println(n, stringWriter.toString());
    }

    static {
        if (Boolean.getBoolean("Debug")) {
            System.out.println("Debug attivo: " + new File(logFile).getAbsolutePath());
            logLevel = 0;
        }
        dformat = DateFormat.getDateTimeInstance(3, 3, Locale.ITALY);
    }
}

