/*
 * Decompiled with CFR 0.152.
 */
package setimanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import setimanager.DirFilter;
import setimanager.Log;
import setimanager.Utils;

public class DialogSelectDirs
extends JDialog
implements ActionListener {
    JPanel pnlSelectDirs = new JPanel();
    JList lstDirectories = new JList();
    JButton btnRemoveDirectory = new JButton();
    JButton btnAddDirectory = new JButton();
    JButton btnScanDirectories = new JButton();
    JPanel jPanel2 = new JPanel();
    JButton btnOK = new JButton();
    JButton btnCancel = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JFileChooser dlgCorrentDirectory;
    Properties configuration = null;

    public DialogSelectDirs(Frame frame) {
        super(frame, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DefaultListModel defaultListModel = new DefaultListModel();
        this.lstDirectories.setModel(defaultListModel);
        this.btnRemoveDirectory.setText("Remove");
        this.btnRemoveDirectory.addActionListener(this);
        this.btnAddDirectory.setText("Add...");
        this.btnAddDirectory.addActionListener(this);
        this.btnScanDirectories.setText("Scan");
        this.btnScanDirectories.addActionListener(this);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(this);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.pnlSelectDirs.setLayout(this.gridBagLayout1);
        this.getContentPane().add((Component)this.pnlSelectDirs, "Center");
        this.pnlSelectDirs.add((Component)this.btnRemoveDirectory, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlSelectDirs.add((Component)new JScrollPane(this.lstDirectories, 20, 30), new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlSelectDirs.add((Component)this.btnAddDirectory, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlSelectDirs.add((Component)this.btnScanDirectories, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.btnOK, null);
        this.jPanel2.add((Component)this.btnCancel, null);
        this.pack();
    }

    public void setConfiguration(Properties properties) {
        int n = Utils.getSubdirCount(properties);
        this.configuration = properties;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.addDir(Utils.getSubdir(this.configuration, n2));
                ++n2;
            }
        }
    }

    public Properties getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Properties();
        }
        return this.configuration;
    }

    boolean isSetiDir(File file) {
        if (new File(file, "state.sah").exists()) {
            Log.println(3, "Found state.sah in " + file);
            return true;
        }
        Log.println(3, "state.sah not found in " + file);
        return false;
    }

    File[] findSetiSubdirs(File file) {
        File[] fileArray = null;
        File[] fileArray2 = null;
        Vector<File> vector = new Vector<File>();
        Log.println(2, "Scanning " + file);
        if (this.isSetiDir(file)) {
            Log.println(3, "Adding '" + file + "'");
            vector.addElement(file);
        }
        if ((fileArray2 = file.listFiles(DirFilter.dirFilter)) != null) {
            int n = 0;
            while (n < fileArray2.length) {
                File[] fileArray3 = this.findSetiSubdirs(fileArray2[n]);
                if (fileArray3 != null) {
                    int n2 = 0;
                    while (n2 < fileArray3.length) {
                        vector.addElement(fileArray3[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            fileArray = new File[vector.size()];
            vector.toArray(fileArray);
        } else {
            fileArray = null;
        }
        return fileArray;
    }

    void scanDirs() {
        if (this.getDirectoryDialog().getSelectedFile() != null) {
            File[] fileArray = this.getDirectoryDialog().getSelectedFile().isDirectory() ? this.findSetiSubdirs(this.getDirectoryDialog().getSelectedFile()) : null;
            ((DefaultListModel)this.lstDirectories.getModel()).clear();
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    this.addDir(fileArray[n]);
                    ++n;
                }
            }
            this.pack();
        }
    }

    void addDir(File file) {
        Log.println(3, "Adding '" + file + "'");
        ((DefaultListModel)this.lstDirectories.getModel()).addElement(file);
        this.pack();
    }

    void removeDir(File file) {
        Log.println(3, "Removing '" + file + "'");
        ((DefaultListModel)this.lstDirectories.getModel()).removeElement(file);
        this.pack();
    }

    void removeDir(int n) {
        Log.println(3, "Removing " + n);
        ((DefaultListModel)this.lstDirectories.getModel()).removeElementAt(n);
        this.pack();
    }

    JFileChooser getDirectoryDialog() {
        if (this.dlgCorrentDirectory == null) {
            this.dlgCorrentDirectory = new JFileChooser("");
            this.dlgCorrentDirectory.setFileSelectionMode(1);
        }
        return this.dlgCorrentDirectory;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            Utils.setSubdirs(this.configuration, this.lstDirectories.getModel());
            Utils.saveConfig(this.configuration);
            ((Component)this).setVisible(false);
        } else if (object == this.btnCancel) {
            ((Component)this).setVisible(false);
        } else if (object == this.btnRemoveDirectory) {
            if (this.lstDirectories.getSelectedIndex() >= 0) {
                this.removeDir(this.lstDirectories.getSelectedIndex());
            }
        } else if (object == this.btnAddDirectory) {
            if (this.getDirectoryDialog().showOpenDialog(this) == 0 && this.getDirectoryDialog().getSelectedFile() != null) {
                if (this.isSetiDir(this.getDirectoryDialog().getSelectedFile())) {
                    this.addDir(this.getDirectoryDialog().getSelectedFile());
                } else {
                    JOptionPane.showMessageDialog(this, "Not a SETI directory!");
                }
            }
        } else if (object == this.btnScanDirectories && this.getDirectoryDialog().showOpenDialog(this) == 0 && this.getDirectoryDialog().getSelectedFile() != null) {
            this.scanDirs();
        }
    }
}

