/*
 * Decompiled with CFR 0.152.
 */
package setimanager;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import setimanager.CFGSelectDirs;
import setimanager.DirFilter;
import setimanager.Log;
import setimanager.PercentComponent;
import setimanager.Utils;

public class DialogConfigure
extends JDialog
implements ActionListener {
    JTabbedPane tabPanel = new JTabbedPane();
    JPanel pnlGeneral = new JPanel();
    CFGSelectDirs pnlSelectDirs = null;
    PercentComponent percentComponent = null;
    JPanel pnlButtons = new JPanel();
    JButton btnOK = new JButton();
    JButton btnCancel = new JButton();
    Properties configuration = null;
    String[] gaugeTypes = new String[]{"Full circle", "Top half circle", "Bottom half circle", "Left half circle", "Right half circle", "Upper right quarter circle", "Lower right quarter circle", "Upper left quarter circle", "Lower left quarter circle"};
    String[] needleStyles = new String[]{"Tailed Pointer", "Pointer", "Tailed Arrow", "Arrow", "Triangle"};
    String[] tickStyles = new String[]{"Diamond", "Triangle", "Reverse Triangle", "Rectangle", "Line", "Circle"};
    JLabel jLabel1 = new JLabel();
    JSlider jSlider1 = new JSlider();

    public DialogConfigure(Frame frame) {
        super(frame, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DefaultListModel defaultListModel = new DefaultListModel();
        this.jLabel1.setText("Columns");
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setMajorTickSpacing(5);
        this.jSlider1.setMinimum(1);
        this.jSlider1.setValue(2);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setMaximum(10);
        this.jSlider1.setSnapToTicks(true);
        this.getContentPane().add((Component)this.tabPanel, "Center");
        this.tabPanel.add((Component)this.pnlGeneral, "General");
        this.pnlGeneral.add((Component)this.jLabel1, null);
        this.pnlGeneral.add((Component)this.jSlider1, null);
        this.pnlSelectDirs = new CFGSelectDirs();
        this.tabPanel.add((Component)this.pnlSelectDirs, "Directories");
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(this);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.pnlButtons.add((Component)this.btnOK, null);
        this.pnlButtons.add((Component)this.btnCancel, null);
        this.pack();
    }

    public void show() {
        if (!this.percentComponent.getClass().getName().equals(this.configuration.getProperty("setimanager.PercentIndicator", "setimanager.percent.ProgressBar"))) {
            this.tabPanel.remove(this.percentComponent.getComponent(this.configuration));
            this.percentComponent = null;
        }
        super.show();
    }

    public void setConfiguration(Properties properties) {
        int n = Utils.getSubdirCount(properties);
        this.configuration = properties;
        this.pnlSelectDirs.clearDirs();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                this.pnlSelectDirs.addDir(Utils.getSubdir(this.configuration, n2));
                ++n2;
            }
        }
        try {
            this.percentComponent = (PercentComponent)Class.forName(this.configuration.getProperty("setimanager.PercentIndicator", "setimanager.percent.ProgressBar")).newInstance();
            this.tabPanel.add((Component)this.percentComponent.getConfigComponent(this.configuration), "Indicator Options");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    public Properties getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Properties();
        }
        return this.configuration;
    }

    boolean isSetiDir(File file) {
        if (new File(file, "state.sah").exists()) {
            Log.println(3, "Found state.sah in " + file);
            return true;
        }
        Log.println(3, "state.sah not found in " + file);
        return false;
    }

    File[] findSetiSubdirs(File file) {
        File[] fileArray = null;
        File[] fileArray2 = null;
        Vector<File> vector = new Vector<File>();
        Log.println(2, "Scanning " + file);
        if (this.isSetiDir(file)) {
            Log.println(3, "Adding '" + file + "'");
            vector.addElement(file);
        }
        if ((fileArray2 = file.listFiles(DirFilter.dirFilter)) != null) {
            int n = 0;
            while (n < fileArray2.length) {
                File[] fileArray3 = this.findSetiSubdirs(fileArray2[n]);
                if (fileArray3 != null) {
                    int n2 = 0;
                    while (n2 < fileArray3.length) {
                        vector.addElement(fileArray3[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (vector.size() > 0) {
            fileArray = new File[vector.size()];
            vector.toArray(fileArray);
        } else {
            fileArray = null;
        }
        return fileArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOK) {
            this.percentComponent.confirmConfig();
            Utils.setSubdirs(this.configuration, this.pnlSelectDirs.lstDirectories.getModel());
            Utils.saveConfig(this.configuration);
            ((Component)this).setVisible(false);
        } else if (object == this.btnCancel) {
            this.percentComponent.cancelConfig();
            ((Component)this).setVisible(false);
        }
    }
}

